/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.analytics;

import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.analytics.WindowExpression;
import org.hotrod.runtime.livesql.expressions.analytics.WindowFunctionOverStage;
import org.hotrod.runtime.livesql.expressions.analytics.WindowableFunction;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;

public abstract class AnalyticFunction<T>
implements WindowableFunction<T> {
    private String functionName;
    protected Expression<?> expression;

    protected AnalyticFunction(String functionName, Expression<?> expression) {
        this.functionName = functionName;
        this.expression = expression;
    }

    @Override
    public WindowFunctionOverStage<T> over() {
        return new WindowFunctionOverStage(new WindowExpression(this));
    }

    @Override
    public void renderBaseTo(QueryWriter w) {
        this.renderHead(w);
        this.renderTail(w);
    }

    protected void renderHead(QueryWriter w) {
        w.write(this.functionName);
        w.write("(");
        if (this.expression != null) {
            this.expression.renderTo(w);
        }
    }

    protected void renderTail(QueryWriter w) {
        w.write(")");
    }
}

