/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.analytics;

import java.util.List;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.analytics.WindowableFunction;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.Separator;

public class WindowExpression<T>
extends Expression<T> {
    private WindowableFunction<T> windowablefunction;
    private List<Expression<?>> partitionBy;
    private List<OrderingTerm> orderBy;
    private FrameUnit frameUnit;
    private FrameBound frameStart;
    private Integer offsetStart;
    private FrameBound frameEnd;
    private Integer offsetEnd;
    private FrameExclusion frameExclusion;

    public WindowExpression(WindowableFunction<T> windowablefunction) {
        super(2);
        this.windowablefunction = windowablefunction;
        this.partitionBy = null;
        this.orderBy = null;
        this.frameUnit = null;
        this.frameStart = null;
        this.offsetStart = null;
        this.frameEnd = null;
        this.offsetEnd = null;
        this.frameExclusion = null;
    }

    void setPartitionBy(List<Expression<?>> partitionBy) {
        this.partitionBy = partitionBy;
    }

    void setOrderBy(List<OrderingTerm> orderBy) {
        this.orderBy = orderBy;
    }

    void setFrameUnit(FrameUnit frameUnit) {
        this.frameUnit = frameUnit;
    }

    void setFrameStart(FrameBound frameStart, Integer offsetStart) {
        this.frameStart = frameStart;
        this.offsetStart = offsetStart;
    }

    void setFrameEnd(FrameBound frameEnd, Integer offsetEnd) {
        this.frameEnd = frameEnd;
        this.offsetEnd = offsetEnd;
    }

    void setFrameExclusion(FrameExclusion frameExclusion) {
        this.frameExclusion = frameExclusion;
    }

    @Override
    public void renderTo(QueryWriter w) {
        Separator sep;
        boolean hasOrderBy;
        this.windowablefunction.renderBaseTo(w);
        w.write(" over(");
        boolean hasPartitionBy = this.partitionBy != null && !this.partitionBy.isEmpty();
        boolean bl = hasOrderBy = this.orderBy != null && !this.orderBy.isEmpty();
        if (hasPartitionBy) {
            w.write("partition by ");
            sep = new Separator();
            for (Expression<?> expression : this.partitionBy) {
                w.write(sep.render());
                this.renderInner(expression, w);
            }
        }
        if (hasOrderBy) {
            if (hasPartitionBy) {
                w.write(" ");
            }
            w.write("order by ");
            sep = new Separator();
            for (OrderingTerm orderingTerm : this.orderBy) {
                w.write(sep.render());
                orderingTerm.renderTo(w);
            }
        }
        if (this.frameUnit != null) {
            w.write(" " + this.frameUnit.render() + " ");
            if (this.frameEnd == null) {
                w.write(this.frameStart.render(this.offsetStart));
            } else {
                w.write("between ");
                w.write(this.frameStart.render(this.offsetStart));
                w.write(" and ");
                w.write(this.frameEnd.render(this.offsetEnd));
            }
            if (this.frameExclusion != null) {
                w.write(" " + this.frameExclusion.render());
            }
        }
        w.write(")");
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        for (Expression<?> e : this.partitionBy) {
            e.validateTableReferences(tableReferences, ag);
        }
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        for (Expression<?> e : this.partitionBy) {
            e.designateAliases(ag);
        }
    }

    public static enum FrameExclusion {
        EXCLUDE_CURRENT_ROW("exclude current row"),
        EXCLUDE_GROUP("exclude group"),
        EXCLUDE_TIES("exclude ties"),
        EXCLUDE_NO_OTHERS("exclude no others");

        private String caption;

        private FrameExclusion(String caption) {
            this.caption = caption;
        }

        public String render() {
            return this.caption;
        }
    }

    public static enum FrameBound {
        UNBOUNDED_PRECEDING("unbounded preceding"),
        OFFSET_PRECEDING("preceding"),
        CURRENT_ROW("current row"),
        OFFSET_FOLLOWING("following"),
        UNBOUNDED_FOLLOWING("unbounded following");

        private String caption;

        private FrameBound(String caption) {
            this.caption = caption;
        }

        public String render(Integer offset) {
            StringBuilder sb = new StringBuilder();
            if (this == OFFSET_PRECEDING || this == OFFSET_FOLLOWING) {
                sb.append("" + offset + " ");
            }
            sb.append(this.caption);
            return sb.toString();
        }
    }

    public static enum FrameUnit {
        ROWS("rows"),
        RANGE("range"),
        GROUPS("groups");

        private String caption;

        private FrameUnit(String caption) {
            this.caption = caption;
        }

        public String render() {
            return this.caption;
        }
    }
}

