/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.caseclause;

import java.util.ArrayList;
import java.util.List;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;

public class CaseClause<T>
extends Expression<T> {
    private List<CaseWhen<T>> whens = new ArrayList<CaseWhen<T>>();
    private Expression<T> elseValue;

    public CaseClause(Predicate predicate, Expression<T> value) {
        super(2);
        this.whens.add(new CaseWhen<T>(predicate, value));
        this.elseValue = null;
    }

    void add(Predicate predicate, Expression<T> value) {
        this.whens.add(new CaseWhen<T>(predicate, value));
    }

    void setElse(Expression<T> value) {
        this.elseValue = value;
    }

    @Override
    public void renderTo(QueryWriter w) {
        w.write("case");
        for (CaseWhen<T> when : this.whens) {
            w.write(" when ");
            super.renderInner(when.getPredicate(), w);
            w.write(" then ");
            super.renderInner(when.getValue(), w);
        }
        if (this.elseValue != null) {
            w.write(" else ");
            super.renderInner(this.elseValue, w);
        }
        w.write(" end");
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        for (CaseWhen<T> w : this.whens) {
            ((CaseWhen)w).predicate.validateTableReferences(tableReferences, ag);
            ((CaseWhen)w).value.validateTableReferences(tableReferences, ag);
        }
        if (this.elseValue != null) {
            this.elseValue.validateTableReferences(tableReferences, ag);
        }
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        for (CaseWhen<T> w : this.whens) {
            ((CaseWhen)w).predicate.designateAliases(ag);
            ((CaseWhen)w).value.designateAliases(ag);
        }
        if (this.elseValue != null) {
            this.elseValue.designateAliases(ag);
        }
    }

    private static class CaseWhen<T> {
        private Predicate predicate;
        private Expression<T> value;

        public CaseWhen(Predicate predicate, Expression<T> value) {
            this.predicate = predicate;
            this.value = value;
        }

        Predicate getPredicate() {
            return this.predicate;
        }

        Expression<T> getValue() {
            return this.value;
        }
    }
}

