/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.queries.select;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.metadata.Column;
import org.hotrod.runtime.livesql.metadata.DatabaseObject;
import org.hotrod.runtime.livesql.metadata.TableOrView;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CombinableSelect;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.PredicatedJoin;
import org.hotrod.runtime.livesql.queries.select.Query;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.Separator;
import org.hotrod.runtime.util.CUtil;
import org.hotrod.runtime.util.HexaUtils;
import org.hotrod.runtime.util.SUtils;

public abstract class AbstractSelect<R>
extends Query {
    public static final String LIVE_SQL_MAPPER_NAMESPACE = "livesql";
    public static final String LIVE_SQL_MAPPER_STATEMENT_NAME = "select";
    private static final String LIVE_SQL_MAPPER_STATEMENT = "livesql.select";
    private boolean distinct;
    private TableOrView baseTable = null;
    private List<Join> joins = null;
    private Predicate wherePredicate = null;
    private List<Expression<?>> groupBy = null;
    private Predicate havingPredicate = null;
    private SetOperationRenderer.SetOperation setOperation = null;
    private CombinableSelect<R> combinedSelect = null;
    private AbstractSelect<R> parent = null;
    private List<OrderingTerm> orderingTerms = null;
    private Integer offset = null;
    private Integer limit = null;
    private SqlSession sqlSession;
    private String mapperStatement;

    AbstractSelect(SQLDialect sqlDialect, boolean distinct, SqlSession sqlSession, String mapperStatement) {
        super(sqlDialect);
        this.distinct = distinct;
        this.sqlSession = sqlSession;
        this.mapperStatement = mapperStatement == null ? LIVE_SQL_MAPPER_STATEMENT : mapperStatement;
    }

    protected abstract void writeColumns(QueryWriter var1);

    void setBaseTable(TableOrView baseTable) {
        this.baseTable = baseTable;
        this.joins = new ArrayList<Join>();
    }

    void addJoin(Join join) {
        this.joins.add(join);
    }

    void setWhereCondition(Predicate whereCondition) {
        this.wherePredicate = whereCondition;
    }

    void setGroupBy(List<Expression<?>> groupBy) {
        this.groupBy = groupBy;
    }

    void setHavingCondition(Predicate havingCondition) {
        this.havingPredicate = havingCondition;
    }

    void setCombinedSelect(SetOperationRenderer.SetOperation setOperation, CombinableSelect<R> combinedSelect) {
        this.setOperation = setOperation;
        this.combinedSelect = combinedSelect;
    }

    void setParent(AbstractSelect<R> parent) {
        this.parent = parent;
    }

    void setColumnOrderings(List<OrderingTerm> orderingTerms) {
        this.orderingTerms = orderingTerms;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    void setLimit(int limit) {
        this.limit = limit;
    }

    Predicate getWhereCondition() {
        return this.wherePredicate;
    }

    Predicate getHavingCondition() {
        return this.havingPredicate;
    }

    private QueryWriter.LiveSQLStructure prepareQuery() {
        this.validateQuery();
        QueryWriter w = new QueryWriter(this.sqlDialect);
        this.renderTo(w);
        return w.getPreparedQuery();
    }

    public void renderTo(QueryWriter w) {
        PaginationRenderer.PaginationType paginationType = this.sqlDialect.getPaginationRenderer().getPaginationType(this.offset, this.limit);
        if ((this.offset != null || this.limit != null) && paginationType == PaginationRenderer.PaginationType.ENCLOSE) {
            this.sqlDialect.getPaginationRenderer().renderBeginEnclosingPagination(this.offset, this.limit, w);
        }
        w.write("SELECT");
        if (this.distinct) {
            w.write(" distinct");
        }
        if ((this.offset != null || this.limit != null) && paginationType == PaginationRenderer.PaginationType.TOP) {
            w.write("\n  ");
            this.sqlDialect.getPaginationRenderer().renderTopPagination(this.offset, this.limit, w);
        }
        this.writeColumns(w);
        if (this.baseTable != null) {
            w.write("\nFROM " + this.sqlDialect.getIdentifierRenderer().renderSQLObjectName(this.baseTable) + (this.baseTable.getAlias() == null ? "" : " " + this.baseTable.getAlias()));
            for (Join j : this.joins) {
                String joinKeywords = this.sqlDialect.getJoinRenderer().renderJoinKeywords(j);
                w.write("\n" + joinKeywords + " " + this.sqlDialect.getIdentifierRenderer().renderSQLObjectName(j.getTable()) + (j.getTable().getAlias() == null ? "" : " " + j.getTable().getAlias()));
                try {
                    PredicatedJoin pj = (PredicatedJoin)j;
                    if (pj.getJoinPredicate() != null) {
                        w.write(" ON ");
                        pj.getJoinPredicate().renderTo(w);
                        continue;
                    }
                    w.write(" USING (");
                    Separator sep = new Separator();
                    for (Column c : pj.getUsingColumns()) {
                        w.write(sep.render());
                        c.renderSimpleNameTo(w);
                    }
                    w.write(")");
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.wherePredicate != null) {
                w.write("\nWHERE ");
                this.wherePredicate.renderTo(w);
            }
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                w.write("\nGROUP BY ");
                boolean first = true;
                for (Expression<?> expr : this.groupBy) {
                    if (first) {
                        first = false;
                    } else {
                        w.write(", ");
                    }
                    expr.renderTo(w);
                }
            }
            if (this.havingPredicate != null) {
                w.write("\nHAVING ");
                this.havingPredicate.renderTo(w);
            }
            if (this.combinedSelect != null) {
                w.write("\n");
                this.sqlDialect.getSetOperationRenderer().render(this.setOperation, w);
                w.write("\n");
                this.combinedSelect.renderTo(w);
            }
            if (this.orderingTerms != null && !this.orderingTerms.isEmpty()) {
                if (this.combinedSelect != null || this.parent != null) {
                    throw new UnsupportedLiveSQLFeatureException("HotRod does not yet support ORDER BY for combined queries (UNION, UNION ALL, INTERSECT, INTERSECT ALL, EXCEPT, or EXCEPT ALL).");
                }
                w.write("\nORDER BY ");
                boolean first = true;
                for (OrderingTerm term : this.orderingTerms) {
                    if (first) {
                        first = false;
                    } else {
                        w.write(", ");
                    }
                    term.renderTo(w);
                }
            }
        }
        if ((this.offset != null || this.limit != null) && paginationType == PaginationRenderer.PaginationType.BOTTOM) {
            this.sqlDialect.getPaginationRenderer().renderBottomPagination(this.offset, this.limit, w);
        }
        if ((this.offset != null || this.limit != null) && paginationType == PaginationRenderer.PaginationType.ENCLOSE) {
            this.sqlDialect.getPaginationRenderer().renderEndEnclosingPagination(this.offset, this.limit, w);
        }
    }

    public List<R> execute() {
        QueryWriter.LiveSQLStructure q = this.prepareQuery();
        System.out.println("--- SQL ---");
        System.out.println(q.getSQL());
        System.out.println("--- Parameters ---");
        for (String name : q.getParameters().keySet()) {
            Object value = q.getParameters().get(name);
            System.out.println(" * " + name + (value == null ? "" : " (" + value.getClass().getName() + ")") + ": " + value);
        }
        System.out.println("------------------");
        List rows = this.sqlSession.selectList(this.mapperStatement, q.getConsolidatedParameters());
        return rows;
    }

    public String getPreview() {
        QueryWriter.LiveSQLStructure q = this.prepareQuery();
        StringBuilder sb = new StringBuilder();
        sb.append("--- SQL ----------\n");
        sb.append(q.getSQL());
        sb.append("\n--- Parameters ---\n");
        for (String name : q.getParameters().keySet()) {
            Object v;
            Object value = q.getParameters().get(name);
            Integer length = null;
            Object preview = null;
            if (value instanceof String) {
                v = (String)value;
                length = ((String)v).length();
                preview = length <= 250 ? v : ((String)v).substring(0, 250) + "...";
            } else if (value instanceof byte[]) {
                v = (byte[])value;
                length = ((Object)v).length;
                preview = ((Object)v).length < 100 ? HexaUtils.toHexa((byte[])v) : HexaUtils.toHexa((byte[])v, 0, 100) + "...";
            } else {
                preview = "" + value;
            }
            sb.append(" * " + name + (value == null ? "" : " (" + CUtil.renderObjectClass(value) + (length == null ? "" : ", length=" + length) + ")") + ": " + (String)preview + "\n");
        }
        sb.append("------------------");
        return sb.toString();
    }

    private void validateQuery() {
        TableReferences tableReferences = new TableReferences();
        AliasGenerator ag = new AliasGenerator();
        this.validateTableReferences(tableReferences, ag);
        if (tableReferences.getTableReferences().size() > 1) {
            this.assignNonDeclaredAliases(ag);
        }
    }

    public void validateTableReferences(TableReferences tableReferences, AliasGenerator ag) {
        if (this.baseTable != null) {
            this.baseTable.validateTableReferences(tableReferences, ag);
        }
        if (this.joins != null) {
            for (Join orderingTerm : this.joins) {
                orderingTerm.getTable().validateTableReferences(tableReferences, ag);
            }
        }
        if (this.wherePredicate != null) {
            this.wherePredicate.validateTableReferences(tableReferences, ag);
        }
        if (this.groupBy != null) {
            for (Expression expression : this.groupBy) {
                expression.validateTableReferences(tableReferences, ag);
            }
        }
        if (this.havingPredicate != null) {
            this.havingPredicate.validateTableReferences(tableReferences, ag);
        }
        if (this.combinedSelect != null) {
            this.combinedSelect.validateTableReferences(tableReferences, ag);
        }
        if (this.orderingTerms != null) {
            for (OrderingTerm orderingTerm : this.orderingTerms) {
            }
        }
    }

    public void assignNonDeclaredAliases(AliasGenerator ag) {
        if (this.baseTable != null) {
            this.baseTable.designateAliases(ag);
        }
        if (this.joins != null) {
            for (Join orderingTerm : this.joins) {
                orderingTerm.getTable().designateAliases(ag);
            }
        }
        if (this.wherePredicate != null) {
            this.wherePredicate.designateAliases(ag);
        }
        if (this.groupBy != null) {
            for (Expression expression : this.groupBy) {
                expression.designateAliases(ag);
            }
        }
        if (this.havingPredicate != null) {
            this.havingPredicate.designateAliases(ag);
        }
        if (this.orderingTerms != null) {
            for (OrderingTerm orderingTerm : this.orderingTerms) {
            }
        }
    }

    public static class AliasGenerator {
        private Set<String> used = new HashSet<String>();
        private char letter = (char)97;
        private int seq = 0;

        public void register(String alias, DatabaseObject databaseObject) {
            if (alias == null) {
                return;
            }
            if (alias.isEmpty()) {
                throw new InvalidLiveSQLStatementException("Empty alias found for " + databaseObject.getType().toLowerCase() + " " + databaseObject.renderUnescapedName() + ". Any specified alias for a table or view must be non-empty. " + "Use any combination of alphanumeric characters as an alias. " + "Usually aliases are very short, commonly a single letter.");
            }
            if (!this.used.add(alias)) {
                throw new InvalidLiveSQLStatementException("Same alias '" + alias + "' for tables/views cannot be used multiple times in a Live SQL statement. " + "If a query includes multiple tables or views " + "two of them cannot share the same alias, even when using subqueries.");
            }
        }

        public String next() {
            while (true) {
                String alias;
                String string = alias = this.seq == 0 ? "" + this.letter : "" + this.letter + this.seq;
                if (this.used.add(alias)) {
                    return alias;
                }
                if (this.letter >= 'z') {
                    this.letter = (char)97;
                    ++this.seq;
                    continue;
                }
                this.letter = (char)(this.letter + '\u0001');
            }
        }
    }

    public static class TableReferences {
        private Set<DatabaseObject> tableReferences = new HashSet<DatabaseObject>();
        private Set<String> aliases = new HashSet<String>();

        public void register(String alias, DatabaseObject databaseObject) {
            if (this.tableReferences.contains(databaseObject)) {
                throw new InvalidLiveSQLStatementException(SUtils.upperFirst(databaseObject.getType()) + " " + databaseObject.renderUnescapedName() + (alias == null ? " (with no alias)" : " (with alias '" + alias + "')") + " is used multiple times in the Live SQL statement. " + "Every table or view can only be used once in the from() or join() methods of a Live SQL statement.");
            }
            this.tableReferences.add(databaseObject);
        }

        public Set<DatabaseObject> getTableReferences() {
            return this.tableReferences;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

