/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.queries.select;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.expressions.Expression;

public class QueryWriter {
    private static final String INDENT = "  ";
    private SQLDialect sqlDialect;
    private AtomicLong n;
    private StringBuilder sb;
    private LinkedHashMap<String, Object> params;
    private int level;
    private int col;

    public QueryWriter(SQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
        this.n = new AtomicLong();
        this.sb = new StringBuilder();
        this.params = new LinkedHashMap();
        this.level = 0;
        this.col = 0;
    }

    public String registerParameter(Object value) {
        String name = "p" + this.n.incrementAndGet();
        this.params.put(name, value);
        return name;
    }

    public void enterLevel() {
        ++this.level;
    }

    public void exitLevel() {
        --this.level;
    }

    public void write(String txt) {
        if (txt != null) {
            String[] lines = txt.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i > 0) {
                    this.newLine();
                }
                this.indent();
                this.sb.append(line);
                this.col += line.length();
            }
            if (txt.endsWith("\n")) {
                this.newLine();
            }
        }
    }

    private void newLine() {
        this.sb.append("\n");
        this.col = 0;
    }

    private void indent() {
        int missingIndents = (this.level * INDENT.length() - this.col) / INDENT.length();
        for (int i = 0; i < missingIndents; ++i) {
            this.sb.append(INDENT);
            this.col += INDENT.length();
        }
    }

    public void write(Expression<?> expression) {
        if (expression != null) {
            expression.renderTo(this);
        }
    }

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public LiveSQLStructure getPreparedQuery() {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        for (String name : this.params.keySet()) {
            p.put(name, this.params.get(name));
        }
        return new LiveSQLStructure(this.sb.toString(), p);
    }

    public static class LiveSQLStructure {
        private String sql;
        private LinkedHashMap<String, Object> parameters;

        public LiveSQLStructure(String sql, LinkedHashMap<String, Object> parameters) {
            this.sql = sql;
            this.parameters = parameters;
        }

        public String getSQL() {
            return this.sql;
        }

        public LinkedHashMap<String, Object> getParameters() {
            return this.parameters;
        }

        public LinkedHashMap<String, Object> getConsolidatedParameters() {
            LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>();
            c.putAll(this.parameters);
            c.put("sql", this.sql);
            return c;
        }
    }
}

