/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.queries.select;

import java.util.List;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.metadata.Column;
import org.hotrod.runtime.livesql.metadata.TableOrView;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.CombinableSelect;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.ExecutableSelect;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.SelectGroupByPhase;
import org.hotrod.runtime.livesql.queries.select.SelectLimitPhase;
import org.hotrod.runtime.livesql.queries.select.SelectOffsetPhase;
import org.hotrod.runtime.livesql.queries.select.SelectOrderByPhase;
import org.hotrod.runtime.livesql.queries.select.SelectWherePhase;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;

public class SelectFromPhase<R>
implements ExecutableSelect<R>,
CombinableSelect<R> {
    private AbstractSelect<R> select;

    SelectFromPhase(AbstractSelect<R> select, TableOrView t) {
        this.select = select;
        this.select.setBaseTable(t);
    }

    public SelectFromPhase<R> join(TableOrView t, Predicate on) {
        this.select.addJoin(new InnerJoin(t, on));
        return this;
    }

    public SelectFromPhase<R> join(TableOrView t, Column ... using) {
        this.select.addJoin(new InnerJoin(t, using));
        return this;
    }

    public SelectFromPhase<R> leftJoin(TableOrView t, Predicate on) {
        this.select.addJoin(new LeftOuterJoin(t, on));
        return this;
    }

    public SelectFromPhase<R> leftJoin(TableOrView t, Column ... using) {
        this.select.addJoin(new LeftOuterJoin(t, using));
        return this;
    }

    public SelectFromPhase<R> rightJoin(TableOrView t, Predicate on) {
        this.select.addJoin(new RightOuterJoin(t, on));
        return this;
    }

    public SelectFromPhase<R> rightJoin(TableOrView t, Column ... using) {
        this.select.addJoin(new RightOuterJoin(t, using));
        return this;
    }

    public SelectFromPhase<R> fullJoin(TableOrView t, Predicate on) {
        this.select.addJoin(new FullOuterJoin(t, on));
        return this;
    }

    public SelectFromPhase<R> fullJoin(TableOrView t, Column ... using) {
        this.select.addJoin(new FullOuterJoin(t, using));
        return this;
    }

    public SelectFromPhase<R> crossJoin(TableOrView t) {
        this.select.addJoin(new CrossJoin(t));
        return this;
    }

    public SelectFromPhase<R> naturalJoin(TableOrView t) {
        this.select.addJoin(new NaturalInnerJoin(t));
        return this;
    }

    public SelectFromPhase<R> naturalLeftJoin(TableOrView t) {
        this.select.addJoin(new NaturalLeftOuterJoin(t));
        return this;
    }

    public SelectFromPhase<R> naturalRightJoin(TableOrView t) {
        this.select.addJoin(new NaturalRightOuterJoin(t));
        return this;
    }

    public SelectFromPhase<R> naturalFullJoin(TableOrView t) {
        this.select.addJoin(new NaturalFullOuterJoin(t));
        return this;
    }

    public SelectFromPhase<R> unionJoin(TableOrView t) {
        this.select.addJoin(new UnionJoin(t));
        return this;
    }

    public SelectWherePhase<R> where(Predicate predicate) {
        return new SelectWherePhase<R>(this.select, predicate);
    }

    public SelectGroupByPhase<R> groupBy(Expression<?> ... columns) {
        return new SelectGroupByPhase<R>(this.select, columns);
    }

    public SelectOrderByPhase<R> orderBy(OrderingTerm ... orderingTerms) {
        return new SelectOrderByPhase<R>(this.select, orderingTerms);
    }

    public SelectOffsetPhase<R> offset(int offset) {
        return new SelectOffsetPhase<R>(this.select, offset);
    }

    public SelectLimitPhase<R> limit(int limit) {
        return new SelectLimitPhase<R>(this.select, limit);
    }

    @Override
    public void renderTo(QueryWriter w) {
        this.select.renderTo(w);
    }

    @Override
    public List<R> execute() {
        return this.select.execute();
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        this.select.validateTableReferences(tableReferences, ag);
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        this.select.assignNonDeclaredAliases(ag);
    }

    @Override
    public void setParent(AbstractSelect<R> parent) {
        this.select.setParent(parent);
    }

    @Override
    public String getPreview() {
        return this.select.getPreview();
    }
}

