/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.util;

public class HexaUtils {
    private static final String DIGITS = "0123456789abcdef";

    public static String toHexa(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        return HexaUtils.toHexa(byteArray, 0, byteArray.length);
    }

    public static String toHexa(byte[] byteArray, int start, int end) {
        if (byteArray == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < end; ++i) {
            int b = byteArray[i];
            if (b < 0) {
                b += 256;
            }
            int hi = b / 16;
            int lo = b & 0xF;
            sb.append(DIGITS.charAt(hi));
            sb.append(DIGITS.charAt(lo));
        }
        return sb.toString();
    }

    public static String toHexa(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        int hi = i / 16;
        int lo = i & 0xF;
        return "" + DIGITS.charAt(hi) + DIGITS.charAt(lo);
    }

    public static byte[] toByteArray(String hexa) {
        if (hexa == null) {
            return null;
        }
        byte[] bytes = new byte[hexa.length() / 2];
        int i = 0;
        while (i + 1 < hexa.length()) {
            int hi = DIGITS.indexOf(hexa.charAt(i));
            if (hi == -1) {
                throw new IllegalArgumentException("Character '" + DIGITS.indexOf(hexa.charAt(i)) + "' is not an hexa character.");
            }
            int lo = DIGITS.indexOf(hexa.charAt(i + 1));
            if (lo == -1) {
                throw new IllegalArgumentException("Character '" + DIGITS.indexOf(hexa.charAt(i + 1)) + "' is not an hexa character.");
            }
            bytes[i / 2] = (byte)(hi * 16 + lo);
            i += 2;
        }
        return bytes;
    }

    public static String charToHexa(char c) {
        int v = c < 0 ? c + 65536 : c;
        String rendered = HexaUtils.toHexa((byte)(v / 256)) + "/" + HexaUtils.toHexa((byte)(v % 256));
        return rendered;
    }
}

