/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.dynamicsql.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.hotrod.runtime.dynamicsql.DynamicSQLEvaluationException;
import org.hotrod.runtime.dynamicsql.DynamicSQLParameters;
import org.hotrod.runtime.dynamicsql.EvaluationFeedback;
import org.hotrod.runtime.dynamicsql.expressions.DynamicExpression;
import org.hotrod.runtime.exceptions.InvalidJexlExpressionException;

public class WhenExpression
extends DynamicExpression {
    private JexlExpression test;
    private DynamicExpression[] expressions;

    public WhenExpression(String test, DynamicExpression ... expressions) {
        try {
            this.test = JEXL_ENGINE.createExpression(test);
        }
        catch (JexlException e) {
            throw new InvalidJexlExpressionException("Invalid test expression: " + test + " (" + e.getMessage() + ")");
        }
        this.expressions = expressions;
    }

    @Override
    public EvaluationFeedback evaluate(StringBuilder out, DynamicSQLParameters variables) throws DynamicSQLEvaluationException {
        Object obj = null;
        try {
            obj = this.test.evaluate((JexlContext)variables);
        }
        catch (Exception e) {
            throw new DynamicSQLEvaluationException("Could not evaluate the test condition '" + this.test.getSourceText() + "' on the <when> tag: " + e.getMessage());
        }
        if (obj == null) {
            throw new DynamicSQLEvaluationException("The test condition of the <when> tag '" + this.test.getSourceText() + "' evaluated to null, but must evaluate to either true or false.");
        }
        try {
            Boolean cond = (Boolean)obj;
            if (cond.booleanValue()) {
                for (DynamicExpression expr : this.expressions) {
                    expr.evaluate(out, variables);
                }
            }
            return new EvaluationFeedback(cond);
        }
        catch (ClassCastException e) {
            throw new DynamicSQLEvaluationException("The test condition on the <when> tag '" + this.test.getSourceText() + "' must evaluate to a boolean value, but resulted in an object of class '" + obj.getClass() + "'.");
        }
    }

    @Override
    public List<Object> getConstructorParameters() {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> stringParams = new ArrayList<String>();
        stringParams.add(this.test.getSourceText());
        params.add(stringParams);
        params.addAll(Arrays.asList(this.expressions));
        return params;
    }
}

