/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.json;

import org.hotrod.runtime.json.JSONValue;

public class JSONString
implements JSONValue {
    private String value;

    public JSONString(String value) {
        this.value = value;
    }

    @Override
    public String render() {
        if (this.value == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '/') {
                sb.append("\\/");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c < ' ') {
                sb.append(JSONString.escapeChar(c));
                continue;
            }
            sb.append(c);
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String escapeChar(char c) {
        char i = c;
        return "\\u" + String.format("%04x", i);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONString other = (JSONString)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

