/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeFieldExpression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class DerbyDialect
extends SQLDialect {
    public DerbyDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[A-Z][A-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Full outer joins are not supported in Derby database");
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in Derby database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in Derby database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                if (!(offset == null && limit == null || DerbyDialect.this.versionIsAtLeast(10, 5))) {
                    throw new UnsupportedLiveSQLFeatureException("This version of Derby (" + DerbyDialect.this.renderVersion() + ") does not support the OFFSET or LIMIT clauses. Derby versions 10.5 and newer do");
                }
                return PaginationRenderer.PaginationType.BOTTOM;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In Derby pagination cannot be rendered at the top");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (offset != null) {
                    w.write("\nOFFSET " + offset + " ROWS");
                }
                if (limit != null) {
                    w.write("\nFETCH NEXT " + limit + " ROWS ONLY");
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In Derby pagination cannot be rendered in an enclosing way");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In Derby pagination cannot be rendered in an enclosing way");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Apache Derby does not support the INTERSECT ALL set operation. The database engine accepts it, but it executes it as an INTERSECT clause. Nevertheless, it can be simulated using a semi join");
                    }
                    case EXCEPT: {
                        w.write("EXCEPT");
                        break;
                    }
                    case EXCEPT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Apache Derby does not support the EXCEPT ALL set operation. The database engine accepts it, but it executes it as an EXCEPT clause. Nevertheless, it can be simulated using an anti join");
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                throw new UnsupportedLiveSQLFeatureException("GROUP_CONCAT() is not supported in Derby database");
            }

            @Override
            public void power(QueryWriter w, Expression<Number> x, Expression<Number> exponent) {
                w.write("exp(");
                exponent.renderTo(w);
                w.write(" * ln(");
                x.renderTo(w);
                w.write("))");
            }

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "ln", x);
                } else {
                    w.write("(");
                    this.write(w, "ln", x);
                    w.write(" / ");
                    this.write(w, "ln", base);
                    w.write(")");
                }
            }

            @Override
            public void round(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                throw new UnsupportedLiveSQLFeatureException("ROUND() is not supported in Derby database");
            }

            @Override
            public void trunc(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                throw new UnsupportedLiveSQLFeatureException("TRUNC() is not supported in Derby database");
            }

            @Override
            public void concat(QueryWriter w, List<Expression<String>> strings) {
                w.write("(");
                Separator sep = new Separator(" || ");
                for (Expression<String> s : strings) {
                    w.write(sep.render());
                    s.renderTo(w);
                }
                w.write(")");
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("current_date");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("current_time");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current_timestamp");
            }

            @Override
            public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
                throw new UnsupportedLiveSQLFeatureException("DATETIME() is not supported in Derby database");
            }

            @Override
            public void extract(QueryWriter w, Expression<Date> datetime, DateTimeFieldExpression field) {
                throw new UnsupportedLiveSQLFeatureException("EXTRACT() is not supported in Derby database");
            }
        };
    }
}

