/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hotrod.runtime.livesql.dialects.DB2Dialect;
import org.hotrod.runtime.livesql.dialects.DerbyDialect;
import org.hotrod.runtime.livesql.dialects.H2Dialect;
import org.hotrod.runtime.livesql.dialects.HyperSQLDialect;
import org.hotrod.runtime.livesql.dialects.MariaDBDialect;
import org.hotrod.runtime.livesql.dialects.MySQLDialect;
import org.hotrod.runtime.livesql.dialects.OracleDialect;
import org.hotrod.runtime.livesql.dialects.PostgreSQLDialect;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SQLServerDialect;
import org.hotrod.runtime.livesql.dialects.SybaseASEDialect;

public class SQLDialectFactory {
    private static final String TOOL_NAME = "HotRod";
    private DataSource dataSource = null;
    private String dialect = null;
    private String databaseName = null;
    private String versionString = null;
    private Integer majorVersion = null;
    private Integer minorVersion = null;
    private SQLDialect sqlDialect = null;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public void setMajorVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDialect getSqlDialect() {
        if (this.sqlDialect == null) {
            SQLDialectFactory sQLDialectFactory = this;
            synchronized (sQLDialectFactory) {
                if (this.sqlDialect == null) {
                    this.sqlDialect = this.resolveSqlDialect();
                }
            }
        }
        return this.sqlDialect;
    }

    private SQLDialect resolveSqlDialect() {
        if (this.dataSource != null && this.dialect != null) {
            throw new RuntimeException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "Either the 'dataSource' or 'dialect' property can be set, but not both.");
        }
        if (this.dataSource == null && this.dialect == null) {
            throw new RuntimeException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "Either 'dataSource' or 'dialect' must be specified.");
        }
        if (this.dataSource != null) {
            try {
                return this.resolveFromDatasource();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        try {
            return this.resolveFromDialect();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private SQLDialect resolveFromDialect() throws SQLException {
        if (this.databaseName == null) {
            throw new SQLException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "The 'databaseName' property is not set.\n" + "For most dialects this property is not relevant and you can specify an empty string. " + "The typical exception to the rule is IBM DB2 where z/OS versions differ considerably from LUW versions, even when the version numbers are similar.");
        }
        if (this.versionString == null) {
            throw new SQLException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "The 'versionString' property is not set.\n" + "For most dialects this property is not relevant and you can specify an empty string. " + "The typical exception to the rule is for MariaDB implementations where only the version string can identify it from MySQL (but not the version number).");
        }
        if (this.majorVersion == null) {
            throw new SQLException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "The 'majorVersion' property is not set.\n" + "This property helps to identify the SQL subdialect. " + "For example, the Oracle 12.1 SQL subdialect implements OFFSET differently compared to older versions.");
        }
        if (this.minorVersion == null) {
            throw new SQLException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "The 'minorVersion' property is not set.\n" + "This property helps to identify the SQL subdialect. " + "For example, the Oracle 12.1 SQL subdialect implements OFFSET differently compared to older versions.");
        }
        return Dialect.resolveDialect(this.dialect, this.databaseName, this.versionString, this.majorVersion, this.minorVersion);
    }

    private SQLDialect resolveFromDatasource() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        DatabaseMetaData dm = conn.getMetaData();
        String name = dm.getDatabaseProductName();
        String version = dm.getDatabaseProductVersion();
        int majorVersion = dm.getDatabaseMajorVersion();
        int minorVersion = dm.getDatabaseMinorVersion();
        String uName = name.toUpperCase();
        if (name.equalsIgnoreCase("ORACLE")) {
            return new OracleDialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("HSQL")) {
            return new HyperSQLDialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("H2")) {
            return new H2Dialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("MYSQL")) {
            String productVersion = dm.getDatabaseProductVersion().toLowerCase();
            if (productVersion != null && productVersion.contains("mariadb")) {
                return new MariaDBDialect(name, version, majorVersion, minorVersion);
            }
            return new MySQLDialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("ADAPTIVE SERVER ENTERPRISE")) {
            return new SybaseASEDialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("DB2")) {
            return new DB2Dialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("POSTGRESQL")) {
            return new PostgreSQLDialect(name, version, majorVersion, minorVersion);
        }
        if (name.startsWith("Microsoft SQL Server")) {
            return new SQLServerDialect(name, version, majorVersion, minorVersion);
        }
        if (uName.startsWith("APACHE DERBY")) {
            return new DerbyDialect(name, version, majorVersion, minorVersion);
        }
        throw new SQLException("[" + this.getClass().getSimpleName() + "] Could not resolve the SQL dialect. " + "The database product reported by the JDBC driver '" + name + "' is not supported by " + TOOL_NAME + ".");
    }

    public static enum Dialect {
        ORACLE,
        DB2,
        POSTGRESQL,
        SQL_SERVER,
        MARIADB,
        MYSQL,
        SYBASE_ASE,
        H2,
        HYPERSQL,
        DERBY;


        public static SQLDialect resolveDialect(String dialect, String databaseName, String versionString, Integer majorVersion, Integer minorVersion) {
            if (ORACLE.name().equals(dialect)) {
                return new OracleDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (DB2.name().equals(dialect)) {
                return new DB2Dialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (POSTGRESQL.name().equals(dialect)) {
                return new PostgreSQLDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (SQL_SERVER.name().equals(dialect)) {
                return new SQLServerDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (MARIADB.name().equals(dialect)) {
                return new MariaDBDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (MYSQL.name().equals(dialect)) {
                return new MySQLDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (SYBASE_ASE.name().equals(dialect)) {
                return new SybaseASEDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (H2.name().equals(dialect)) {
                return new H2Dialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (DERBY.name().equals(dialect)) {
                return new DerbyDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            if (HYPERSQL.name().equals(dialect)) {
                return new HyperSQLDialect(databaseName, versionString, majorVersion, minorVersion);
            }
            StringBuilder sb = new StringBuilder();
            for (Dialect d : Dialect.values()) {
                sb.append(" - " + d.name() + "\n");
            }
            throw new RuntimeException("[" + SQLDialectFactory.class.getSimpleName() + "] Could not resolve the SQL dialect. Invalid property 'dialect' with value '" + dialect + "'. Valid values are:\n" + sb.toString());
        }
    }
}

