/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeFieldExpression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class SybaseASEDialect
extends SQLDialect {
    public SybaseASEDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[a-zA-Z][a-zA-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Full outer joins are not supported in Sybase ASE database");
                }
                if (join instanceof CrossJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Cross joins are not supported in Sybase ASE database");
                }
                if (join instanceof NaturalInnerJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Natural joins are not supported in Sybase ASE database");
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Natural joins are not supported in Sybase ASE database");
                }
                if (join instanceof NaturalRightOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Natural joins are not supported in Sybase ASE database");
                }
                if (join instanceof NaturalFullOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Natural joins are not supported in Sybase ASE database");
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in Sybase ASE database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in Sybase ASE database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                if (offset != null) {
                    throw new UnsupportedLiveSQLFeatureException("OFFSET is not supported Sybase ASE");
                }
                return PaginationRenderer.PaginationType.TOP;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                if (offset != null) {
                    throw new UnsupportedLiveSQLFeatureException("OFFSET is not supported Sybase ASE");
                }
                w.write(" top " + limit);
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered at the bottom in Sybase ASE");
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in enclosing fashion in Sybase ASE");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in enclosing fashion in Sybase ASE");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not support the INTERSECT set operation. Nevertheless, it can be simulated using a semi join");
                    }
                    case INTERSECT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not support the INTERSECT ALL set operation. Nevertheless, it can be simulated using a semi join");
                    }
                    case EXCEPT: {
                        throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not support the EXCEPT set operation. Nevertheless, it can be simulated using an anti join");
                    }
                    case EXCEPT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not support the EXCEPT ALL set operation. Nevertheless, it can be simulated using an anti join");
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                throw new UnsupportedLiveSQLFeatureException("GROUP_CONCAT() is not supported in Sybase ASE");
            }

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "log", x);
                } else {
                    w.write("(");
                    this.write(w, "log", x);
                    w.write(" / ");
                    this.write(w, "log", base);
                    w.write(")");
                }
            }

            @Override
            public void round(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                if (places == null) {
                    throw new UnsupportedLiveSQLFeatureException("Sybase ASE requires the number of decimal places to be specified on the ROUND() function");
                }
                this.write(w, "round", x, places);
            }

            @Override
            public void trunc(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not support the TRUNC()function");
            }

            @Override
            public void concat(QueryWriter w, List<Expression<String>> strings) {
                w.write("(");
                Separator sep = new Separator(" || ");
                for (Expression<String> s : strings) {
                    w.write(sep.render());
                    s.renderTo(w);
                }
                w.write(")");
            }

            @Override
            public void length(QueryWriter w, Expression<String> string) {
                this.write(w, "char_length", string);
            }

            @Override
            public void locate(QueryWriter w, Expression<String> substring, Expression<String> string, Expression<Number> from) {
                if (from == null) {
                    this.write(w, "charindex", substring, string);
                } else {
                    this.write(w, "charindex", substring, string, from);
                }
            }

            @Override
            public void substr(QueryWriter w, Expression<String> string, Expression<Number> from, Expression<Number> length) {
                if (length == null) {
                    throw new UnsupportedLiveSQLFeatureException("Sybase ASE requires the length parameter to be be specified on the SUBSTR() function");
                }
                this.write(w, "substring", string, from, length);
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("current_date()");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("current_time");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("getdate()");
            }

            @Override
            public void date(QueryWriter w, Expression<Date> datetime) {
                throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not suppor the DATE() function");
            }

            @Override
            public void time(QueryWriter w, Expression<Date> datetime) {
                throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not suppor the TIME() function");
            }

            @Override
            public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
                throw new UnsupportedLiveSQLFeatureException("Sybase ASE does not suppor the DATETIME() function");
            }

            @Override
            public void extract(QueryWriter w, Expression<Date> datetime, DateTimeFieldExpression field) {
                w.write("datepart(");
                field.renderTo(w);
                w.write(", ");
                datetime.renderTo(w);
                w.write(")");
            }
        };
    }
}

