/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.numbers;

import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.numbers.Abs;
import org.hotrod.runtime.livesql.expressions.numbers.Div;
import org.hotrod.runtime.livesql.expressions.numbers.Log;
import org.hotrod.runtime.livesql.expressions.numbers.Minus;
import org.hotrod.runtime.livesql.expressions.numbers.Mult;
import org.hotrod.runtime.livesql.expressions.numbers.Neg;
import org.hotrod.runtime.livesql.expressions.numbers.NumberCoalesce;
import org.hotrod.runtime.livesql.expressions.numbers.NumberConstant;
import org.hotrod.runtime.livesql.expressions.numbers.Plus;
import org.hotrod.runtime.livesql.expressions.numbers.Power;
import org.hotrod.runtime.livesql.expressions.numbers.Remainder;
import org.hotrod.runtime.livesql.expressions.numbers.Round;
import org.hotrod.runtime.livesql.expressions.numbers.Signum;
import org.hotrod.runtime.livesql.expressions.numbers.Trunc;

public abstract class NumberExpression
extends Expression<Number> {
    protected NumberExpression(int precedence) {
        super(precedence);
    }

    public NumberExpression coalesce(NumberExpression a) {
        return new NumberCoalesce(this, a);
    }

    public NumberExpression coalesce(Number a) {
        return new NumberCoalesce(this, new NumberConstant(a));
    }

    public NumberExpression plus(NumberExpression n) {
        return new Plus(this, n);
    }

    public NumberExpression plus(Number n) {
        return new Plus(this, new NumberConstant(n));
    }

    public NumberExpression minus(NumberExpression n) {
        return new Minus(this, n);
    }

    public NumberExpression minus(Number n) {
        return new Minus(this, new NumberConstant(n));
    }

    public NumberExpression mult(NumberExpression n) {
        return new Mult(this, n);
    }

    public NumberExpression mult(Number n) {
        return new Mult(this, new NumberConstant(n));
    }

    public NumberExpression div(NumberExpression n) {
        return new Div(this, n);
    }

    public NumberExpression div(Number n) {
        return new Div(this, new NumberConstant(n));
    }

    public NumberExpression remainder(NumberExpression n) {
        return new Remainder(this, n);
    }

    public NumberExpression remainder(Number n) {
        return new Remainder(this, new NumberConstant(n));
    }

    public NumberExpression pow(NumberExpression exponent) {
        return new Power(this, exponent);
    }

    public NumberExpression pow(Number exponent) {
        return new Power(this, new NumberConstant(exponent));
    }

    public NumberExpression log(NumberExpression base) {
        return new Log(this, base);
    }

    public NumberExpression log(Number base) {
        return new Log(this, new NumberConstant(base));
    }

    public NumberExpression round() {
        return new Round(this, new NumberConstant((Number)0));
    }

    public NumberExpression round(NumberExpression places) {
        return new Round(this, places);
    }

    public NumberExpression round(Number places) {
        return new Round(this, new NumberConstant(places));
    }

    public NumberExpression trunc() {
        return new Trunc(this, new NumberConstant((Number)0));
    }

    public NumberExpression trunc(NumberExpression places) {
        return new Trunc(this, places);
    }

    public NumberExpression trunc(Number places) {
        return new Trunc(this, new NumberConstant(places));
    }

    public NumberExpression neg() {
        return new Neg(this);
    }

    public NumberExpression abs() {
        return new Abs(this);
    }

    public NumberExpression signum() {
        return new Signum(this);
    }
}

