/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.util;

import java.util.HashMap;
import java.util.Map;
import org.hotrod.runtime.util.SQLField;
import org.hotrod.runtime.util.SQLLogicalExpression;
import org.hotrod.runtime.util.SQLSimpleExpression;
import org.hotrod.runtime.util.SQLTable;

public class SQLCompositeExpression
implements SQLLogicalExpression {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String renderedExpression;

    public SQLCompositeExpression(CompositeExpressionOperator operator, SQLLogicalExpression ... expressions) {
        this.doTheRendering(operator, expressions);
    }

    @Deprecated
    public SQLCompositeExpression(SQLLogicalExpression expression, CompositeExpressionOperator operator, SQLLogicalExpression expression2) {
        this.doTheRendering(operator, expression, expression2);
    }

    @Override
    public String render() {
        return this.renderedExpression;
    }

    private void doTheRendering(CompositeExpressionOperator operator, SQLLogicalExpression ... expressions) {
        String op = operator.equals((Object)CompositeExpressionOperator.AND) ? " AND " : " OR ";
        StringBuffer sb = new StringBuffer(expressions[0].render());
        this.parameters = expressions[0].getParameters();
        for (int i = 1; i < expressions.length; ++i) {
            sb.append(op + expressions[i].render());
            this.parameters.putAll(expressions[i].getParameters());
        }
        this.renderedExpression = "(" + sb.toString() + ")";
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public static void main(String[] args) {
        SQLSimpleExpression a = new SQLSimpleExpression(new SQLField(new SQLTable("T1", "TA1"), "T1.A"), SQLSimpleExpression.SimpleExpressionOperator.LIKE, "dalt%");
        System.out.println(a.render());
        SQLSimpleExpression b = new SQLSimpleExpression(new SQLField("B"), SQLSimpleExpression.SimpleExpressionOperator.EQUALS, "1");
        SQLSimpleExpression c = new SQLSimpleExpression(new SQLField("C"), SQLSimpleExpression.SimpleExpressionOperator.IN, "1", "2", "3", "4");
        SQLSimpleExpression d = new SQLSimpleExpression(new SQLField("D"), SQLSimpleExpression.SimpleExpressionOperator.NOT_EQUAL, "8");
        SQLSimpleExpression e = new SQLSimpleExpression(new SQLField("E"), SQLSimpleExpression.SimpleExpressionOperator.LOWER_OR_EQUAL, "66");
        SQLSimpleExpression f = new SQLSimpleExpression(new SQLField("F"), SQLSimpleExpression.SimpleExpressionOperator.LOWER_THAN, "7");
        System.out.println(b.render());
        System.out.println(c.render());
        System.out.println(d.render());
        System.out.println(e.render());
        System.out.println(f.render());
        System.out.println();
        SQLCompositeExpression composite = new SQLCompositeExpression(a, CompositeExpressionOperator.AND, (SQLLogicalExpression)b);
        SQLCompositeExpression composite2 = new SQLCompositeExpression(e, CompositeExpressionOperator.AND, (SQLLogicalExpression)f);
        System.out.println(composite.render());
        composite = new SQLCompositeExpression(composite, CompositeExpressionOperator.OR, (SQLLogicalExpression)c);
        System.out.println(composite.render());
        composite = new SQLCompositeExpression(composite, CompositeExpressionOperator.AND, (SQLLogicalExpression)composite2);
        System.out.println(composite.render());
        composite = new SQLCompositeExpression(CompositeExpressionOperator.AND, a, b, c, d, e, f);
        System.out.println(composite.render());
    }

    public String toString() {
        return this.render();
    }

    public static enum CompositeExpressionOperator {
        AND,
        OR;

    }
}

