/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.hotrod.runtime.util.ListWriter;

public class SUtils {
    public static boolean isEmpty(String txt) {
        return txt == null || txt.trim().isEmpty();
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static String capitalize(String txt) {
        if (txt == null) {
            return null;
        }
        String lower = txt.trim().toLowerCase();
        if (lower.isEmpty()) {
            return "";
        }
        boolean inWord = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lower.length(); ++i) {
            char c = lower.charAt(i);
            if (!inWord) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            inWord = c >= 'a' && c <= 'z';
        }
        return sb.toString();
    }

    public static String sentenceFormat(String txt) {
        if (txt == null) {
            return null;
        }
        return txt.substring(0, 1).toUpperCase() + txt.substring(1);
    }

    public static String lowerFirst(String txt) {
        if (txt == null) {
            return null;
        }
        if (txt.isEmpty()) {
            return txt;
        }
        return txt.substring(0, 1).toLowerCase() + txt.substring(1);
    }

    public static String upperFirst(String txt) {
        if (txt == null) {
            return null;
        }
        if (txt.isEmpty()) {
            return txt;
        }
        return txt.substring(0, 1).toUpperCase() + txt.substring(1);
    }

    public static boolean startsWithUpperCaseLetter(String txt) {
        if (txt == null || txt.isEmpty()) {
            return false;
        }
        return SUtils.isUpperCase(txt.charAt(0));
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean startsWithLowerCaseLetter(String txt) {
        if (txt == null || txt.isEmpty()) {
            return false;
        }
        return SUtils.isLowerCase(txt.charAt(0));
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean startsWithIgnoreCase(String txt, String prefix) {
        if (txt == null || prefix == null) {
            return false;
        }
        if (prefix.length() > txt.length()) {
            return false;
        }
        return prefix.equalsIgnoreCase(txt.substring(0, prefix.length()));
    }

    public static boolean endsWithIgnoreCase(String txt, String suffix) {
        if (txt == null || suffix == null) {
            return false;
        }
        if (suffix.length() > txt.length()) {
            return false;
        }
        return suffix.equalsIgnoreCase(txt.substring(txt.length() - suffix.length()));
    }

    public static String getFiller(char c, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getFiller(String filler, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(filler);
        }
        return sb.toString();
    }

    public static String indent(String txt, int indent) {
        if (txt == null) {
            return null;
        }
        ListWriter w = new ListWriter(SUtils.getFiller(' ', indent), "", "\n");
        for (String line : txt.split("\n")) {
            w.add(line);
        }
        return w.toString();
    }

    public static String escapeJavaString(String txt) {
        if (txt == null) {
            return null;
        }
        return txt.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f");
    }

    public static String escapeXmlBody(String txt) {
        if (txt == null) {
            return null;
        }
        return txt.replace("&", "&amp;").replace("<", "&lt;");
    }

    public static String escapeXmlAttribute(String txt) {
        if (txt == null) {
            return null;
        }
        return txt.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static String loadFileAsString(File f) throws IOException {
        return SUtils.loadFileAsString(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileAsString(File f, String readerEncoding) throws IOException {
        BufferedReader r = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            r = readerEncoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), readerEncoding)) : new BufferedReader(new FileReader(f));
            while ((line = r.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public static void saveStringToFile(String txt, File f) throws IOException {
        Writer w = null;
        try {
            w = new BufferedWriter(new FileWriter(f));
            w.write(txt);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public static int countMatches(String txt, String searchText) {
        int count = 0;
        for (int pos = 0; pos <= txt.length() && (pos = txt.indexOf(searchText, pos)) != -1; pos += searchText.length()) {
            ++count;
        }
        return count;
    }

    public static String alignRight(String txt, int width) {
        if (txt == null) {
            return null;
        }
        if (txt.length() >= width) {
            return txt;
        }
        String filler = SUtils.getFiller(' ', width - txt.length());
        return filler + txt;
    }

    public static String alignLeft(String txt, int width) {
        if (txt == null) {
            return null;
        }
        if (txt.length() >= width) {
            return txt;
        }
        String filler = SUtils.getFiller(' ', width - txt.length());
        return txt + filler;
    }

    public static List<String> slice(String txt, int width) {
        ArrayList<String> slices = new ArrayList<String>();
        int len = txt.length();
        for (int i = 0; i < len; i += width) {
            slices.add(txt.substring(i, Math.min(len, i + width)));
        }
        return slices;
    }
}

