/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.torcs.ctp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hotrod.torcs.QueryExecution;
import org.hotrod.torcs.ctp.CTPPlanRetriever;
import org.hotrod.torcs.ctp.CTPPlanRetrieverFactory;
import org.hotrod.torcs.ctp.LogResistantFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TorcsCTP {
    @Autowired
    private CTPPlanRetrieverFactory ctpPlanRetrieverFactory;
    private LogResistantFormatter fmt = new LogResistantFormatter();
    private Map<Integer, CTPPlanRetriever> planRetrievers = new HashMap<Integer, CTPPlanRetriever>();

    public List<String> getEstimatedCTPExecutionPlan(QueryExecution execution) throws SQLException, CTPPlanRetrieverFactory.UnsupportedTorcsCTPDatabaseException, IOException {
        CTPPlanRetriever r = this.planRetrievers.get(execution.getDataSourceReference().getId());
        if (r == null) {
            r = this.get(execution);
        }
        return this.fmt.render(r.getEstimatedCTPExecutionPlan(execution));
    }

    public void setSegmentSize(int size) {
        this.fmt.setSegmentSize(size);
    }

    private synchronized CTPPlanRetriever get(QueryExecution execution) throws SQLException, CTPPlanRetrieverFactory.UnsupportedTorcsCTPDatabaseException {
        CTPPlanRetriever r = this.planRetrievers.get(execution.getDataSourceReference().getId());
        if (r == null) {
            r = this.ctpPlanRetrieverFactory.getTorcsCTPPlanRetriever(execution);
            this.planRetrievers.put(execution.getDataSourceReference().getId(), r);
        }
        return r;
    }
}

