/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.torcs.ctp.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.hotrod.torcs.QueryExecution;
import org.hotrod.torcs.ctp.CTPPlanRetriever;
import org.hotrod.torcs.setters.index.CouldNotToGuessDataTypeException;
import org.hotrod.torcs.setters.index.DataTypeNotImplementedException;
import org.hotrod.torcs.setters.index.IndexSetter;
import org.springframework.stereotype.Component;

@Component
public class SQLServerCTPPlanRetriever
implements CTPPlanRetriever {
    private static final String PLAN_TYPE = "XML";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEstimatedCTPExecutionPlan(QueryExecution execution) throws SQLException {
        DataSource ds = execution.getDataSourceReference().getDataSource();
        try (Connection conn = ds.getConnection();){
            conn.setAutoCommit(false);
            try (Statement stIni = conn.createStatement();){
                stIni.execute("set showplan_XML on");
                if (execution.getNameSetters().isEmpty()) {
                    try (Statement st = conn.createStatement();){
                        SQLServerPlanSQL pp = new SQLServerPlanSQL(execution.getSQL(), execution.getIndexSetters());
                        String sql = pp.render();
                        st.execute(sql);
                        String string = SQLServerCTPPlanRetriever.getResult(st);
                        return string;
                    }
                }
                throw new UnsupportedOperationException("Cannot retrieve SQL Server plan that use CallableStatements, or that use parameter setting using names instead of indexes.");
            }
            finally {
                try (Statement stEnd = conn.createStatement();){
                    stEnd.execute("set showplan_XML off");
                }
                finally {
                    conn.rollback();
                }
            }
        }
    }

    private static String getResult(Statement ps) throws SQLException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        ResultSet rs = ps.getResultSet();
        while (rs.next()) {
            String line = rs.getString(1);
            if (!first) {
                sb.append("\n");
            }
            sb.append(line);
            first = false;
        }
        return sb.toString();
    }

    public class SQLServerPlanSQL {
        private Collection<IndexSetter> setters;
        private List<String> parameters = new ArrayList<String>();
        private String psql;

        private SQLServerPlanSQL(String sql, Collection<IndexSetter> setters) {
            if (sql == null) {
                throw new IllegalArgumentException("SQL statement cannot be null");
            }
            this.setters = setters;
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (pos < sql.length()) {
                int apos = sql.indexOf(39, pos);
                int qm = sql.indexOf(63, pos);
                if (apos == -1 && qm == -1) {
                    sb.append(sql.substring(pos));
                    pos = sql.length();
                    continue;
                }
                if (apos != -1 && qm == -1) {
                    pos = this.processApostrophe(sql, sb, pos, apos);
                    continue;
                }
                if (apos == -1 && qm != -1) {
                    pos = this.processQuestionMark(sql, sb, pos, qm);
                    continue;
                }
                if (apos < qm) {
                    pos = this.processApostrophe(sql, sb, pos, apos);
                    continue;
                }
                pos = this.processQuestionMark(sql, sb, pos, qm);
            }
            this.psql = sb.toString();
        }

        private int processApostrophe(String sql, StringBuilder sb, int pos, int apos) {
            int ipos = apos + 1;
            sb.append(sql.substring(pos, ipos));
            while (ipos < sql.length()) {
                int ix = sql.indexOf(39, ipos);
                if (ix == -1) {
                    sb.append(sql.substring(ipos));
                    ipos = sql.length();
                    return ipos;
                }
                if (ix + 1 < sql.length() && sql.charAt(ix + 1) == '\'') {
                    sb.append(sql.substring(ipos, ix + 2));
                    ipos = ix + 2;
                    continue;
                }
                sb.append(sql.substring(ipos, ix + 1));
                ipos = ix + 1;
                return ipos;
            }
            return sql.length();
        }

        private int processQuestionMark(String sql, StringBuilder sb, int pos, int qm) {
            sb.append(sql.substring(pos, qm));
            String p = "@p" + this.parameters.size();
            this.parameters.add(p);
            sb.append(p);
            return qm + 1;
        }

        private String render() {
            StringBuilder sb = new StringBuilder();
            Iterator<IndexSetter> it = this.setters.iterator();
            for (String p : this.parameters) {
                IndexSetter s = it.hasNext() ? it.next() : null;
                String dbType = this.guessDBType(s);
                sb.append("declare " + p + " " + dbType + ";\n");
            }
            sb.append(this.psql);
            return sb.toString();
        }

        private String guessDBType(IndexSetter s) {
            if (s == null) {
                return "varchar";
            }
            try {
                return s.guessSQLServerDataType();
            }
            catch (DataTypeNotImplementedException e) {
                return "varchar";
            }
            catch (CouldNotToGuessDataTypeException e) {
                return "varchar";
            }
        }
    }
}

