/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiExtraContext;
import org.hotswap.agent.util.ReflectionHelper;

public class HaCdiCommons {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HaCdiCommons.class);
    private static final String BEAN_REGISTRY_FIELD = "$$ha$beanRegistry";
    private static final Map<Class<? extends Annotation>, Class<? extends Context>> scopeToContextMap = new HashMap<Class<? extends Annotation>, Class<? extends Context>>();
    private static Map<HaCdiExtraContext, Boolean> extraContexts = new HashMap<HaCdiExtraContext, Boolean>();

    public static boolean isInExtraScope(Bean<?> bean) {
        Class beanClass = bean.getBeanClass();
        for (HaCdiExtraContext extraContext : extraContexts.keySet()) {
            if (!extraContext.containsBeanInstances(beanClass)) continue;
            return true;
        }
        return false;
    }

    public static void transformContext(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        HaCdiCommons.addBeanRegistryToContext(classPool, ctClass);
        HaCdiCommons.transformGet1(classPool, ctClass);
        HaCdiCommons.transformGet2(classPool, ctClass);
        LOGGER.debug(ctClass.getName() + " - patched by bean registration.", new Object[0]);
    }

    public static void addBeanRegistryToContext(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtField beanRegistryFld = CtField.make((String)"public static java.util.Map $$ha$beanRegistry;", (CtClass)ctClass);
        ctClass.addField(beanRegistryFld);
    }

    public static void transformGet1(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod methGet1 = ctClass.getDeclaredMethod("get", new CtClass[]{classPool.get("javax.enterprise.context.spi.Contextual")});
        methGet1.insertAfter(HaCdiCommons.getRegistrationCode());
    }

    public static void transformGet2(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod methGet2 = ctClass.getDeclaredMethod("get", new CtClass[]{classPool.get("javax.enterprise.context.spi.Contextual"), classPool.get("javax.enterprise.context.spi.CreationalContext")});
        methGet2.insertAfter(HaCdiCommons.getRegistrationCode());
    }

    private static String getRegistrationCode() {
        String result = "if($$ha$beanRegistry==null){$$ha$beanRegistry=new java.util.concurrent.ConcurrentHashMap();}org.hotswap.agent.plugin.cdi.HaCdiCommons.registerContextClass(this.getScope(),this.getClass());if($_!=null && $1 instanceof javax.enterprise.inject.spi.Bean){String key=((javax.enterprise.inject.spi.Bean) $1).getBeanClass().getName();java.util.Map m=$$ha$beanRegistry.get(key);if(m==null) {synchronized($$ha$beanRegistry){m=$$ha$beanRegistry.get(key);if(m==null) {m=java.util.Collections.synchronizedMap(new java.util.WeakHashMap());$$ha$beanRegistry.put(key,m);}}}m.put($_, java.lang.Boolean.TRUE);}";
        return result;
    }

    public static List<Object> getBeanInstances(Bean<?> bean) {
        ArrayList<Object> result = new ArrayList<Object>();
        Class<? extends Context> contextClass = HaCdiCommons.getContextClass(bean.getScope());
        if (contextClass != null) {
            Map beanRegistry = (Map)HaCdiCommons.getBeanRegistry(contextClass);
            if (beanRegistry != null) {
                Map m = (Map)beanRegistry.get(bean.getBeanClass().getName());
                if (m != null) {
                    result.addAll(m.keySet());
                } else {
                    LOGGER.debug("BeanRegistry is empty for bean class '{}'", new Object[]{bean.getBeanClass().getName()});
                }
            } else {
                LOGGER.error("BeanRegistry field not found in context class '{}'", new Object[]{contextClass.getName()});
            }
        }
        for (HaCdiExtraContext extraContext : extraContexts.keySet()) {
            List<Object> instances = extraContext.getBeanInstances(bean.getBeanClass());
            if (instances == null) continue;
            result.addAll(instances);
        }
        return result;
    }

    private static Object getBeanRegistry(Class clazz) {
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(BEAN_REGISTRY_FIELD);
                return field.get(null);
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static void registerContextClass(Class<? extends Annotation> scope, Class<? extends Context> contextClass) {
        Map<Class<? extends Annotation>, Class<? extends Context>> currentScopeToContextMap = HaCdiCommons.getCurrentScopeToContextMap();
        if (!currentScopeToContextMap.containsKey(scope)) {
            LOGGER.debug("Registering scope '{}' to scopeToContextMap@{}", new Object[]{scope.getName(), System.identityHashCode(currentScopeToContextMap)});
            currentScopeToContextMap.put(scope, contextClass);
        }
    }

    public static Class<? extends Context> getContextClass(Class<? extends Annotation> scope) {
        return HaCdiCommons.getCurrentScopeToContextMap().get(scope);
    }

    public static boolean isRegisteredScope(Class<? extends Annotation> scope) {
        return HaCdiCommons.getContextClass(scope) != null;
    }

    private static Map<Class<? extends Annotation>, Class<? extends Context>> getCurrentScopeToContextMap() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(HaCdiCommons.class.getName());
                if (clazz != HaCdiCommons.class) {
                    return (Map)ReflectionHelper.get(null, clazz, (String)"scopeToContextMap");
                }
            }
            catch (Exception e) {
                LOGGER.error("getCurrentScopeToContextMap '{}' failed", new Object[]{e.getMessage()});
            }
        }
        return scopeToContextMap;
    }

    public static void registerExtraContext(HaCdiExtraContext extraContext) {
        extraContexts.put(extraContext, Boolean.TRUE);
    }

    public static void unregisterExtraContext(HaCdiExtraContext extraContext) {
        extraContexts.remove(extraContext);
    }
}

