/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hotswap.agent.annotation.Versions;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.versions.DeploymentInfo;
import org.hotswap.agent.versions.VersionMatchResult;
import org.hotswap.agent.versions.matcher.MethodMatcher;
import org.hotswap.agent.versions.matcher.PluginMatcher;

public class PluginAnnotation<T extends Annotation> {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PluginAnnotation.class);
    Class<?> pluginClass;
    Object plugin;
    T annotation;
    Field field;
    Method method;
    final PluginMatcher pluginMatcher;
    final MethodMatcher methodMatcher;
    final boolean fallback;

    public PluginAnnotation(Class<?> pluginClass, Object plugin, T annotation, Method method) {
        this.pluginClass = pluginClass;
        this.plugin = plugin;
        this.annotation = annotation;
        this.method = method;
        if (method != null && Modifier.isStatic(method.getModifiers())) {
            this.pluginMatcher = new PluginMatcher(pluginClass);
            this.methodMatcher = new MethodMatcher(method);
            Versions v = pluginClass.getAnnotation(Versions.class);
            this.fallback = v == null || v.fallback() ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        } else {
            this.pluginMatcher = null;
            this.methodMatcher = null;
            this.fallback = Boolean.TRUE;
        }
    }

    public PluginAnnotation(Class<?> pluginClass, Object plugin, T annotation, Field field) {
        this.pluginClass = pluginClass;
        this.plugin = plugin;
        this.annotation = annotation;
        this.field = field;
        this.pluginMatcher = null;
        this.methodMatcher = null;
        this.fallback = Boolean.TRUE;
    }

    public Class<?> getPluginClass() {
        return this.pluginClass;
    }

    public Object getPlugin() {
        return this.plugin;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public boolean shouldCheckVersion() {
        return this.plugin == null && (this.pluginMatcher != null && this.pluginMatcher.isApply() || this.methodMatcher != null && this.methodMatcher.isApply());
    }

    public boolean isFallBack() {
        return this.fallback;
    }

    public boolean matches(DeploymentInfo deploymentInfo) {
        if (deploymentInfo == null || this.pluginMatcher == null && this.methodMatcher == null) {
            LOGGER.debug("No matchers, apply", new Object[0]);
            return true;
        }
        if (this.pluginMatcher != null && this.pluginMatcher.isApply() && VersionMatchResult.REJECTED.equals((Object)this.pluginMatcher.matches(deploymentInfo))) {
            LOGGER.debug("Plugin matcher rejected", new Object[0]);
            return false;
        }
        if (this.methodMatcher != null && this.methodMatcher.isApply() && VersionMatchResult.REJECTED.equals((Object)this.methodMatcher.matches(deploymentInfo))) {
            LOGGER.debug("Method matcher rejected", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginAnnotation that = (PluginAnnotation)o;
        if (!this.annotation.equals(that.annotation)) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        return this.plugin.equals(that.plugin);
    }

    public int hashCode() {
        int result = this.plugin.hashCode();
        result = 31 * result + this.annotation.hashCode();
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PluginAnnotation{plugin=" + this.plugin + ", annotation=" + this.annotation + ", field=" + this.field + ", method=" + this.method + '}';
    }
}

