/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.LoaderClassPath;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.AppClassLoaderExecutor;
import org.hotswap.agent.versions.DeploymentInfo;

public class PluginClassFileTransformer
implements ClassFileTransformer {
    protected static AgentLogger LOGGER = AgentLogger.getLogger(PluginClassFileTransformer.class);
    private final OnClassLoadEvent onClassLoadAnnotation;
    private final PluginAnnotation<OnClassLoadEvent> pluginAnnotation;
    private final List<LoadEvent> events;
    private final PluginManager pluginManager;

    public PluginClassFileTransformer(PluginManager pluginManager, PluginAnnotation<OnClassLoadEvent> pluginAnnotation) {
        this.pluginManager = pluginManager;
        this.pluginAnnotation = pluginAnnotation;
        this.onClassLoadAnnotation = pluginAnnotation.getAnnotation();
        this.events = Arrays.asList(this.onClassLoadAnnotation.events());
    }

    public boolean isPluginDisabled(ClassLoader loader) {
        if (loader != null && this.pluginManager != null && this.pluginManager.getPluginConfiguration(loader) != null) {
            return this.pluginManager.getPluginConfiguration(loader).isDisabledPlugin(this.pluginAnnotation.getPluginClass());
        }
        return false;
    }

    public boolean shouldCheckVersion() {
        return this.pluginAnnotation.shouldCheckVersion();
    }

    public boolean isDefaultPlugin() {
        return this.pluginAnnotation.isFallBack();
    }

    public boolean versionMatches(ClassLoader loader) {
        DeploymentInfo info;
        if (this.pluginAnnotation.shouldCheckVersion() && !this.pluginAnnotation.matches(info = DeploymentInfo.fromClassLoader(loader))) {
            LOGGER.debug("SKIPPING METHOD: {}, Deployment info: {}\n did not match with {}\n or {}", this.pluginAnnotation.method, info, this.pluginAnnotation.methodMatcher, this.pluginAnnotation.pluginMatcher);
            return false;
        }
        return true;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined == null ? !this.events.contains((Object)LoadEvent.DEFINE) : !this.events.contains((Object)LoadEvent.REDEFINE)) {
            LOGGER.trace("Not a handled event!", this.events);
            return classfileBuffer;
        }
        if (this.pluginManager.getPluginConfiguration(loader).isDisabledPlugin(this.pluginAnnotation.getPluginClass())) {
            LOGGER.trace("Plugin NOT enabled! {}", this.pluginAnnotation);
            return classfileBuffer;
        }
        return PluginClassFileTransformer.transform(this.pluginManager, this.pluginAnnotation, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public String toString() {
        return "\n\t\t\tPluginClassFileTransformer [pluginAnnotation=" + this.pluginAnnotation + "]";
    }

    private static CtClass createCtClass(byte[] bytes, ClassLoader classLoader) throws IOException {
        ClassPool cp = new ClassPool();
        cp.appendSystemPath();
        cp.appendClassPath(new LoaderClassPath(classLoader));
        return cp.makeClass(new ByteArrayInputStream(bytes));
    }

    protected static boolean isSyntheticClass(String className) {
        return className.contains("$$_javassist") || className.startsWith("com/sun/proxy");
    }

    private static byte[] transform(PluginManager pluginManager, PluginAnnotation<OnClassLoadEvent> pluginAnnotation, ClassLoader classLoader, String className, Class<?> redefiningClass, ProtectionDomain protectionDomain, byte[] bytes) {
        LOGGER.trace("Transforming.... '{}' using: '{}'", className, pluginAnnotation);
        if (pluginAnnotation.getAnnotation().skipSynthetic() && (PluginClassFileTransformer.isSyntheticClass(className) || redefiningClass != null && redefiningClass.isSynthetic())) {
            return bytes;
        }
        if (pluginAnnotation.getAnnotation().skipAnonymous() && className.matches("\\$\\d+$")) {
            return bytes;
        }
        if (classLoader != null) {
            pluginManager.initClassLoader(classLoader, protectionDomain);
        }
        byte[] result = bytes;
        CtClass ctClass = null;
        ArrayList<Object> args = new ArrayList<Object>();
        for (Class<Object> clazz : pluginAnnotation.getMethod().getParameterTypes()) {
            if (clazz.isAssignableFrom(ClassLoader.class)) {
                args.add(classLoader);
                continue;
            }
            if (clazz.isAssignableFrom(String.class)) {
                args.add(className);
                continue;
            }
            if (clazz.isAssignableFrom(Class.class)) {
                args.add(redefiningClass);
                continue;
            }
            if (clazz.isAssignableFrom(ProtectionDomain.class)) {
                args.add(protectionDomain);
                continue;
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                args.add(bytes);
                continue;
            }
            if (clazz.isAssignableFrom(ClassPool.class)) {
                ClassPool classPool = new ClassPool();
                classPool.appendSystemPath();
                LOGGER.trace("Adding loader classpath " + classLoader, new Object[0]);
                classPool.appendClassPath(new LoaderClassPath(classLoader));
                args.add(classPool);
                continue;
            }
            if (clazz.isAssignableFrom(CtClass.class)) {
                try {
                    ctClass = PluginClassFileTransformer.createCtClass(bytes, classLoader);
                    args.add(ctClass);
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error("Unable create CtClass for '" + className + "'.", e, new Object[0]);
                    return result;
                }
            }
            if (clazz.isAssignableFrom(LoadEvent.class)) {
                args.add((Object)(redefiningClass == null ? LoadEvent.DEFINE : LoadEvent.REDEFINE));
                continue;
            }
            if (clazz.isAssignableFrom(AppClassLoaderExecutor.class)) {
                args.add(new AppClassLoaderExecutor(classLoader, protectionDomain));
                continue;
            }
            LOGGER.error("Unable to call init method on plugin '" + pluginAnnotation.getPluginClass() + "'. Method parameter type '" + clazz + "' is not recognized for @Init annotation.", new Object[0]);
            return result;
        }
        try {
            Object resultObject = pluginAnnotation.getMethod().invoke(pluginAnnotation.getPlugin(), args.toArray());
            if (resultObject != null) {
                if (resultObject instanceof byte[]) {
                    result = (byte[])resultObject;
                } else if (resultObject instanceof CtClass) {
                    result = ((CtClass)resultObject).toBytecode();
                    if (resultObject != ctClass) {
                        ((CtClass)resultObject).detach();
                    }
                } else {
                    LOGGER.error("Unknown result of @OnClassLoadEvent method '" + result.getClass().getName() + "'.", new Object[0]);
                }
            }
            if (ctClass != null) {
                if (resultObject == null) {
                    result = ctClass.toBytecode();
                }
                ctClass.detach();
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("IllegalAccessException in transform method on plugin '" + pluginAnnotation.getPluginClass() + "' class '" + className + "'.", e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("InvocationTargetException in transform method on plugin '" + pluginAnnotation.getPluginClass() + "' class '" + className + "'.", e, new Object[0]);
        }
        catch (CannotCompileException e) {
            LOGGER.error("Cannot compile class after manipulation on plugin '" + pluginAnnotation.getPluginClass() + "' class '" + className + "'.", e, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error("IOException in transform method on plugin '" + pluginAnnotation.getPluginClass() + "' class '" + className + "'.", e, new Object[0]);
        }
        return result;
    }
}

