/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.hotswap.agent.logging.AgentLogger;

public class ReflectionHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ReflectionHelper.class);

    public static Object invoke(Object target, Class<?> clazz, String methodName, Class[] parameterTypes, Object ... args) {
        try {
            Method method = null;
            try {
                method = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Illegal arguments method %s.%s(%s) on %s, params %s", clazz.getName(), methodName, Arrays.toString(parameterTypes), target, Arrays.toString(args)), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Error invoking method %s.%s(%s) on %s, params %s", clazz.getName(), methodName, Arrays.toString(parameterTypes), target, Arrays.toString(args)), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("No such method %s.%s(%s) on %s, params %s", clazz.getName(), methodName, Arrays.toString(parameterTypes), target, Arrays.toString(args)), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("No such method %s.%s(%s) on %s, params %s", clazz.getName(), methodName, Arrays.toString(parameterTypes), target, Arrays.toString(args)), e);
        }
    }

    public static Object get(Object target, String fieldName) {
        Class<?> clazz;
        if (target == null) {
            throw new NullPointerException("Target object cannot be null.");
        }
        for (clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("No such field %s.%s on %s", target.getClass(), fieldName, target));
        }
        return ReflectionHelper.get(target, clazz, fieldName);
    }

    public static Object get(Object target, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("No such field %s.%s on %s", clazz.getName(), fieldName, target), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Illegal access field %s.%s on %s", clazz.getName(), fieldName, target), e);
        }
    }

    public static Object getNoException(Object target, Class<?> clazz, String fieldName) {
        try {
            return ReflectionHelper.get(target, clazz, fieldName);
        }
        catch (Exception e) {
            LOGGER.trace("Error getting field {}.{} on object {}", e, clazz, fieldName, target);
            return null;
        }
    }

    public static void set(Object target, Class<?> clazz, String fieldName, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("No such field %s.%s on %s", clazz.getName(), fieldName, target), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Illegal access field %s.%s on %s", clazz.getName(), fieldName, target), e);
        }
    }
}

