/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.classloader;

import java.lang.reflect.Method;
import org.hotswap.agent.logging.AgentLogger;

public class ClassLoaderHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassLoaderHelper.class);
    public static Method findLoadedClass;

    public static boolean isClassLoaded(ClassLoader classLoader, String className) {
        try {
            return findLoadedClass.invoke((Object)classLoader, className) != null;
        }
        catch (Exception e) {
            LOGGER.error("Unable to invoke findLoadedClass on classLoader {}, className {}", e, classLoader, className);
            return false;
        }
    }

    static {
        try {
            findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Unexpected: failed to get ClassLoader findLoadedClass method", e, new Object[0]);
        }
    }
}

