/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.classloader;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.hotswap.agent.logging.AgentLogger;
import sun.misc.URLClassPath;

public class URLClassLoaderHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(URLClassLoaderHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prependClassPath(URLClassLoader classLoader, URL[] extraClassPath) {
        URLClassLoader uRLClassLoader = classLoader;
        synchronized (uRLClassLoader) {
            try {
                Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                URL[] origClassPath = URLClassLoaderHelper.getOrigClassPath(classLoader, ucpField);
                URL[] modifiedClassPath = new URL[origClassPath.length + extraClassPath.length];
                System.arraycopy(extraClassPath, 0, modifiedClassPath, 0, extraClassPath.length);
                System.arraycopy(origClassPath, 0, modifiedClassPath, extraClassPath.length, origClassPath.length);
                ucpField.set(classLoader, (Object)new ExtraURLClassPath(modifiedClassPath));
                LOGGER.debug("Added extraClassPath URLs {} to classLoader {}", Arrays.toString(extraClassPath), classLoader);
            }
            catch (Exception e) {
                LOGGER.error("Unable to add extraClassPath URLs {} to classLoader {}", e, Arrays.toString(extraClassPath), classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWatchResourceLoader(URLClassLoader classLoader, ClassLoader watchResourceLoader) {
        URLClassLoader uRLClassLoader = classLoader;
        synchronized (uRLClassLoader) {
            try {
                Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                URL[] origClassPath = URLClassLoaderHelper.getOrigClassPath(classLoader, ucpField);
                ucpField.set(classLoader, (Object)new ExtraURLClassPath(origClassPath, watchResourceLoader));
                LOGGER.debug("WatchResourceLoader registered to classLoader {}", classLoader);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to register WatchResourceLoader to classLoader {}", e, classLoader);
            }
        }
    }

    private static URL[] getOrigClassPath(URLClassLoader classLoader, Field ucpField) throws IllegalAccessException {
        URLClassPath urlClassPath = (URLClassPath)ucpField.get(classLoader);
        URL[] origClassPath = urlClassPath instanceof ExtraURLClassPath ? ((ExtraURLClassPath)urlClassPath).getOrigClassPath() : classLoader.getURLs();
        return origClassPath;
    }

    private static class ExtraURLClassPath
    extends URLClassPath {
        private ClassLoader watchResourceLoader;
        URL[] origClassPath;

        public ExtraURLClassPath(URL[] origClassPath) {
            super(origClassPath);
            this.origClassPath = origClassPath;
        }

        public ExtraURLClassPath(URL[] origClassPath, ClassLoader watchResourceLoader) {
            super(origClassPath);
            this.origClassPath = origClassPath;
            this.watchResourceLoader = watchResourceLoader;
        }

        public URL findResource(String name, boolean check) {
            URL resource;
            if (this.watchResourceLoader != null && (resource = this.watchResourceLoader.getResource(name)) != null) {
                return resource;
            }
            return super.findResource(name, check);
        }

        public URL[] getOrigClassPath() {
            return this.origClassPath;
        }
    }
}

