/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.scanner.Scanner;
import org.hotswap.agent.util.scanner.ScannerVisitor;

public class ClassPathScanner
implements Scanner {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassPathScanner.class);
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String ZIP_URL_PREFIX = "zip:";
    public static final String FILE_URL_PREFIX = "file:";

    @Override
    public void scan(ClassLoader classLoader, String path, ScannerVisitor visitor) throws IOException {
        Enumeration<URL> en;
        LOGGER.trace("Scanning path {}", path);
        Enumeration<URL> enumeration = en = classLoader == null ? ClassLoader.getSystemResources(path) : classLoader.getResources(path);
        while (en.hasMoreElements()) {
            String uri;
            URL pluginDirURL = en.nextElement();
            File pluginDir = new File(pluginDirURL.getFile());
            if (pluginDir.isDirectory()) {
                this.scanDirectory(pluginDir, visitor);
                continue;
            }
            try {
                uri = pluginDirURL.toURI().toString();
            }
            catch (URISyntaxException e) {
                throw new IOException("Illegal directory URI " + pluginDirURL, e);
            }
            if (uri.startsWith(JAR_URL_PREFIX) || uri.startsWith(ZIP_URL_PREFIX)) {
                String jarFile = uri.substring(uri.indexOf(58) + 1);
                this.scanJar(jarFile, visitor);
                continue;
            }
            LOGGER.warning("Unknown resource type of file " + uri, new Object[0]);
        }
    }

    protected void scanDirectory(File pluginDir, ScannerVisitor visitor) throws IOException {
        LOGGER.trace("Scanning directory " + pluginDir.getName(), new Object[0]);
        for (File file : pluginDir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDirectory(file, visitor);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            visitor.visit(new FileInputStream(file));
        }
    }

    private void scanJar(String urlFile, ScannerVisitor visitor) throws IOException {
        JarFile jarFile;
        String rootEntryPath;
        LOGGER.trace("Scanning JAR file '{}'", urlFile);
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            rootEntryPath = urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
            jarFile = this.getJarFile(jarFileUrl);
        } else {
            rootEntryPath = "";
            jarFile = new JarFile(urlFile);
        }
        if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
            rootEntryPath = rootEntryPath + "/";
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || !entryPath.endsWith(".class")) continue;
            LOGGER.trace("Visiting JAR entry {}", entryPath);
            visitor.visit(jarFile.getInputStream(entry));
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        LOGGER.trace("Opening JAR file " + jarFileUrl, new Object[0]);
        if (jarFileUrl.startsWith(FILE_URL_PREFIX)) {
            try {
                return new JarFile(ClassPathScanner.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring(FILE_URL_PREFIX.length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(location.replace(" ", "%20"));
    }
}

