/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.versions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.spring.io.resource.Resource;
import org.hotswap.agent.util.spring.path.PathMatchingResourcePatternResolver;
import org.hotswap.agent.versions.ManifestInfo;
import org.hotswap.agent.versions.MavenInfo;

public class DeploymentInfo {
    private static AgentLogger LOGGER = AgentLogger.getLogger(DeploymentInfo.class);
    private Set<MavenInfo> maven = new LinkedHashSet<MavenInfo>();
    private Set<ManifestInfo> manifest;

    public DeploymentInfo(Set<MavenInfo> maven, Set<ManifestInfo> manifest) {
        this.maven = maven;
        this.manifest = manifest;
    }

    public Set<ManifestInfo> getManifest() {
        return this.manifest;
    }

    public Set<MavenInfo> getMaven() {
        return this.maven;
    }

    public void setMaven(Set<MavenInfo> maven) {
        this.maven = maven;
    }

    public boolean isEmpty() {
        return this.maven == null || this.maven.size() == 0 || this.manifest == null || this.manifest.isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo)obj;
        if (this.manifest == null ? other.manifest != null : !this.manifest.equals(other.manifest)) {
            return false;
        }
        return !(this.maven == null ? other.maven != null : !this.maven.equals(other.maven));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.manifest == null ? 0 : this.manifest.hashCode());
        result = 31 * result + (this.maven == null ? 0 : this.maven.hashCode());
        return result;
    }

    public void setManifest(Set<ManifestInfo> manifest) {
        this.manifest = manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentInfo fromClassLoader(ClassLoader classloader) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            LinkedHashSet<MavenInfo> maven = new LinkedHashSet<MavenInfo>();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classloader);
            try {
                Enumeration<URL> urls = classloader.getResources("META-INF/maven/");
                while (urls.hasMoreElements()) {
                    URL u = urls.nextElement();
                    try {
                        Object[] resources = resolver.getResources(u.toExternalForm() + "**/pom.properties");
                        if (resources == null) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("META-INF/maven/**/pom.properties FOUND:{}", Arrays.toString(resources));
                        }
                        for (Object resource : resources) {
                            MavenInfo m = DeploymentInfo.getMavenInfo((Resource)resource);
                            if (m == null) continue;
                            maven.add(m);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error trying to find maven properties", e, new Object[0]);
            }
            DeploymentInfo deploymentInfo = new DeploymentInfo(maven, DeploymentInfo.getManifest(classloader));
            return deploymentInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MavenInfo getMavenInfo(Resource resource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("RESOURCE_MAVEN:" + resource.getClass() + "-->" + resource.getDescription() + "----" + resource.getFilename(), new Object[0]);
        }
        try (InputStream is = resource.getInputStream();){
            Properties p = new Properties();
            p.load(is);
            MavenInfo mavenInfo = new MavenInfo(p.getProperty("groupId"), p.getProperty("artifactId"), p.getProperty("version"));
            return mavenInfo;
        }
        catch (IOException e) {
            LOGGER.debug("Error trying to read maven properties", e, new Object[0]);
            return null;
        }
    }

    public static Set<ManifestInfo> getManifest(ClassLoader classloader) {
        LinkedHashSet<ManifestInfo> manifests = new LinkedHashSet<ManifestInfo>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classloader);
        try {
            Enumeration<URL> urls = classloader.getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL u = urls.nextElement();
                try {
                    Object[] resources = resolver.getResources(u.toExternalForm());
                    if (resources == null) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("META-INF/MANIFEST.MF FOUND:\n" + Arrays.toString(resources), new Object[0]);
                    }
                    for (Object resource : resources) {
                        ManifestInfo m = DeploymentInfo.getManifest((Resource)resource);
                        if (m == null) continue;
                        manifests.add(m);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error trying to get manifest entries", e, new Object[0]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error trying to get manifest entries", e, new Object[0]);
        }
        return manifests;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ManifestInfo getManifest(Resource resource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("RESOURCE_MANIFEST:" + resource.getClass() + "-->" + resource.getDescription() + "----" + resource.getFilename(), new Object[0]);
        }
        try (InputStream is = resource.getInputStream();){
            Manifest man = new Manifest(is);
            if (man == null) return null;
            ManifestInfo manifestInfo = new ManifestInfo(man);
            return manifestInfo;
        }
        catch (IOException e) {
            LOGGER.debug("Error trying to read manifest", e, new Object[0]);
        }
        return null;
    }

    public String toString() {
        return "DeploymentInfo [maven=" + this.maven + ", manifest=" + this.manifest + "]";
    }
}

