/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch;

import java.io.IOException;
import org.hotswap.agent.watch.Watcher;
import org.hotswap.agent.watch.nio.TreeWatcherNIO;
import org.hotswap.agent.watch.nio.WatcherNIO2;

public class WatcherFactory {
    public static double JAVA_VERSION = WatcherFactory.getVersion();
    public static boolean IS_WINDOWS = WatcherFactory.isWindows();

    static double getVersion() {
        int pos;
        String version = System.getProperty("java.version");
        int count = 0;
        for (pos = 0; pos < version.length() && count < 2; ++pos) {
            if (version.charAt(pos) != '.') continue;
            ++count;
        }
        return Double.parseDouble(version.substring(0, pos - 1));
    }

    static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public Watcher getWatcher() throws IOException {
        if (JAVA_VERSION >= 1.7) {
            if (IS_WINDOWS) {
                return new TreeWatcherNIO();
            }
            return new WatcherNIO2();
        }
        throw new UnsupportedOperationException("Watcher is implemented only for Java 1.7 (NIO2). JNotify implementation should be added in the future for older Java version support.");
    }
}

