/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hotswap.agent.command.CommandExecutionListener;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;

public class ReflectionCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ReflectionCommand.class);
    private Object target;
    private String className;
    private String methodName;
    private List<Object> params = new ArrayList<Object>();
    private Object plugin;
    private ClassLoader targetClassLoader;
    private CommandExecutionListener commandExecutionListener;

    public ReflectionCommand(Object plugin, String className, String methodName, ClassLoader targetClassLoader, Object ... params) {
        this.plugin = plugin;
        this.className = className;
        this.methodName = methodName;
        this.targetClassLoader = targetClassLoader;
        this.params = Arrays.asList(params);
    }

    public ReflectionCommand(Object plugin, String className, String methodName) {
        this.plugin = plugin;
        this.className = className;
        this.methodName = methodName;
    }

    public ReflectionCommand(Object target, String methodName, Object ... params) {
        this.target = target;
        this.methodName = methodName;
        this.params = Arrays.asList(params);
    }

    public String toString() {
        return "Command{class='" + this.getClassName() + '\'' + ", methodName='" + this.getMethodName() + '\'' + '}';
    }

    public String getClassName() {
        if (this.className == null && this.target != null) {
            this.className = this.target.getClass().getName();
        }
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public ClassLoader getTargetClassLoader() {
        if (this.targetClassLoader == null) {
            this.targetClassLoader = this.target != null ? this.target.getClass().getClassLoader() : PluginManager.getInstance().getPluginRegistry().getAppClassLoader(this.plugin);
        }
        return this.targetClassLoader;
    }

    public void setTargetClassLoader(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
    }

    public CommandExecutionListener getCommandExecutionListener() {
        return this.commandExecutionListener;
    }

    public void setCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.commandExecutionListener = commandExecutionListener;
    }

    @Override
    public void executeCommand() {
        if (this.getTargetClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getTargetClassLoader());
        }
        ClassLoader targetClassLoader = Thread.currentThread().getContextClassLoader();
        String className = this.getClassName();
        String method = this.getMethodName();
        List<Object> params = this.getParams();
        Object result = null;
        try {
            result = this.doExecuteReflectionCommand(targetClassLoader, className, this.target, method, params);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Class {} not found in classloader {}", e, className, targetClassLoader);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("NoClassDefFoundError for class {} in classloader {}", e, className, targetClassLoader);
        }
        catch (InstantiationException e) {
            LOGGER.error("Unable instantiate class {} in classloader {}", e, className, targetClassLoader);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Method {} not public in class {}", e, method, className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Method {} not found in class {}", e, method, className);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error executin method {} in class {}", e, method, className);
        }
        CommandExecutionListener listener = this.getCommandExecutionListener();
        if (listener != null) {
            listener.commandExecuted(result);
        }
    }

    protected Object doExecuteReflectionCommand(ClassLoader targetClassLoader, String className, Object target, String method, List<Object> params) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> classInAppClassLoader = Class.forName(className, true, targetClassLoader);
        LOGGER.trace("Executing command: requestedClassLoader={}, resolvedClassLoader={}, class={}, method={}, params={}", targetClassLoader, classInAppClassLoader.getClassLoader(), classInAppClassLoader, method, params);
        Class[] paramTypes = new Class[params.size()];
        int i = 0;
        for (Object param : params) {
            if (param == null) {
                throw new IllegalArgumentException("Cannot execute for null parameter value");
            }
            paramTypes[i++] = param.getClass();
        }
        Method m = classInAppClassLoader.getDeclaredMethod(method, paramTypes);
        return m.invoke(target, params.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectionCommand)) {
            return false;
        }
        ReflectionCommand that = (ReflectionCommand)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!this.params.equals(that.params)) {
            return false;
        }
        if (this.plugin != null ? !this.plugin.equals(that.plugin) : that.plugin != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.targetClassLoader != null ? !this.targetClassLoader.equals(that.targetClassLoader) : that.targetClassLoader != null);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.params.hashCode();
        result = 31 * result + (this.plugin != null ? this.plugin.hashCode() : 0);
        result = 31 * result + (this.targetClassLoader != null ? this.targetClassLoader.hashCode() : 0);
        return result;
    }
}

