/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.javassist.util.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.bytecode.ClassFile;
import org.hotswap.agent.javassist.util.proxy.SecurityActions;
import sun.misc.Unsafe;

public class DefineClassHelper {
    private static Method defineClass1 = null;
    private static Method defineClass2 = null;
    private static Unsafe sunMiscUnsafe = null;

    public static Class<?> toClass(String className, ClassLoader loader, ProtectionDomain domain, byte[] bcode) throws CannotCompileException {
        if (ClassFile.MAJOR_VERSION >= 53 && sunMiscUnsafe != null) {
            try {
                return sunMiscUnsafe.defineClass(className, bcode, 0, bcode.length, loader, domain);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return DefineClassHelper.toClass2(className, loader, domain, bcode);
    }

    private static Class<?> toClass2(String cname, ClassLoader loader, ProtectionDomain domain, byte[] bcode) throws CannotCompileException {
        try {
            Object[] args;
            Method method;
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{cname, bcode, 0, bcode.length};
            } else {
                method = defineClass2;
                args = new Object[]{cname, bcode, 0, bcode.length, domain};
            }
            return DefineClassHelper.toClass3(method, loader, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new CannotCompileException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CannotCompileException(e);
        }
    }

    private static synchronized Class<?> toClass3(Method method, ClassLoader loader, Object[] args) throws Exception {
        SecurityActions.setAccessible(method, true);
        Class clazz = (Class)method.invoke((Object)loader, args);
        SecurityActions.setAccessible(method, false);
        return clazz;
    }

    static {
        if (ClassFile.MAJOR_VERSION < 53) {
            try {
                Class<?> cl = Class.forName("java.lang.ClassLoader");
                defineClass1 = SecurityActions.getDeclaredMethod(cl, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                defineClass2 = SecurityActions.getDeclaredMethod(cl, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
            }
            catch (Exception e) {
                throw new RuntimeException("cannot initialize");
            }
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            sunMiscUnsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

