/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.HashSet;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.classloader.ClassLoaderPatcher;

@Deprecated
public class ClassLoaderURLPatcher
implements ClassLoaderPatcher {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassLoaderURLPatcher.class);
    private static final String CHECK_RESOURCE = "org/hotswap/agent/config/PluginManager.class";

    @Override
    public boolean isPatchAvailable(ClassLoader classLoader) {
        return classLoader instanceof URLClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void patch(ClassLoader classLoaderFrom, String pluginPath, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        HashSet<ClassLoader> patchedClassLoaders = new HashSet<ClassLoader>();
        if (classLoader != this.getClass().getClassLoader() && !patchedClassLoaders.contains(classLoader)) {
            HashSet<ClassLoader> hashSet = patchedClassLoaders;
            synchronized (hashSet) {
                if (!patchedClassLoaders.contains(classLoader)) {
                    patchedClassLoaders.add(classLoader);
                    if (classLoader instanceof URLClassLoader) {
                        this.doPatchUrlClassLoader((URLClassLoader)classLoader);
                    } else {
                        LOGGER.debug("Unable to patch ClassLoader {} of type {}. Only URLClassLoader(s) can be currently patched.", classLoader, classLoader.getClass().getName());
                    }
                }
            }
        }
    }

    private void doPatchUrlClassLoader(URLClassLoader classLoader) {
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            String url = this.getClass().getClassLoader().getResource(CHECK_RESOURCE).toURI().toString();
            url = url.substring(0, url.length() - CHECK_RESOURCE.length());
            url = this.removeJarPrefixSuffix(url);
            Field field = classLoaderClass.getDeclaredField("ucp");
            field.setAccessible(true);
            Object ucp = field.get(classLoader);
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, new URL(url));
            LOGGER.debug("Classloader {} patched - Added URL '{}' to classpath.", classLoader, url);
        }
        catch (Throwable e) {
            LOGGER.error("Error patching classloader {}", e, classLoader);
        }
    }

    private String removeJarPrefixSuffix(String url) {
        if (url.startsWith("jar:")) {
            url = url.substring("jar:".length());
        }
        if (url.endsWith("!/")) {
            url = url.substring(0, url.length() - "!/".length());
        }
        return url;
    }
}

