/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.versions.matcher;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.hotswap.agent.annotation.Manifest;
import org.hotswap.agent.annotation.Maven;
import org.hotswap.agent.annotation.Versions;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.versions.DeploymentInfo;
import org.hotswap.agent.versions.InvalidVersionSpecificationException;
import org.hotswap.agent.versions.VersionMatchResult;
import org.hotswap.agent.versions.VersionMatcher;
import org.hotswap.agent.versions.matcher.ManifestMatcher;
import org.hotswap.agent.versions.matcher.MavenMatcher;

public class AbstractMatcher
implements VersionMatcher {
    protected AgentLogger LOGGER = AgentLogger.getLogger(this.getClass());
    protected final List<VersionMatcher> matchers = new ArrayList<VersionMatcher>();
    protected boolean shouldApply = Boolean.FALSE;

    public AbstractMatcher(Versions versions) {
        VersionMatcher m;
        if (versions == null) {
            return;
        }
        Maven[] maven = versions.maven();
        Manifest[] manifest = versions.manifest();
        if (maven != null) {
            for (Annotation annotation : maven) {
                try {
                    m = new MavenMatcher((Maven)annotation);
                    if (!((MavenMatcher)m).isApply()) continue;
                    this.matchers.add(m);
                    this.shouldApply = true;
                }
                catch (InvalidVersionSpecificationException e) {
                    this.LOGGER.error("Unable to parse Maven info for {}", e, annotation);
                }
            }
        }
        if (manifest != null) {
            for (Annotation annotation : manifest) {
                try {
                    m = new ManifestMatcher((Manifest)annotation);
                    if (!((ManifestMatcher)m).isApply()) continue;
                    this.matchers.add(m);
                    this.shouldApply = true;
                }
                catch (InvalidVersionSpecificationException e) {
                    this.LOGGER.error("Unable to parse Manifest info for {}", e, annotation);
                }
            }
        }
    }

    @Override
    public boolean isApply() {
        return this.shouldApply;
    }

    @Override
    public VersionMatchResult matches(DeploymentInfo info) {
        if (this.matchers.size() == 0) {
            return VersionMatchResult.SKIPPED;
        }
        for (VersionMatcher m : this.matchers) {
            VersionMatchResult result = m.matches(info);
            if (VersionMatchResult.MATCHED.equals((Object)result)) {
                this.LOGGER.debug("Matched:{}", m);
                return VersionMatchResult.MATCHED;
            }
            if (!VersionMatchResult.REJECTED.equals((Object)result)) continue;
            this.LOGGER.debug("Rejected:{}", m);
            return VersionMatchResult.REJECTED;
        }
        this.LOGGER.debug("Rejected: Matchers existed, none matched!", new Object[0]);
        return VersionMatchResult.REJECTED;
    }

    public String toString() {
        return "AbstractMatcher [matchers=" + this.matchers + ", shouldApply=" + this.shouldApply + "]";
    }
}

