/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.nio.file.Path;

public class PathPair {
    private final Path target;
    private final Path watched;

    public static PathPair get(Path target) {
        return new PathPair(target);
    }

    public static PathPair get(Path target, Path watched) {
        return new PathPair(target, watched);
    }

    public PathPair(Path target) {
        this(target, target);
    }

    public PathPair(Path target, Path watched) {
        this.target = target;
        this.watched = watched;
    }

    public Path getWatched() {
        return this.watched;
    }

    public Path getTarget() {
        return this.target;
    }

    public Path resolve(Path other) {
        return this.watched.resolve(other);
    }

    public boolean isWatching(Path target) {
        return target.startsWith(this.watched);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.watched == null ? 0 : this.watched.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathPair other = (PathPair)obj;
        return !(this.watched == null ? other.watched != null : !this.watched.equals(other.watched));
    }

    public String getShortDescription() {
        if (this.watched != null && this.watched.equals(this.target)) {
            return "PathPair [watched=" + this.watched + "]";
        }
        return "PathPair [target=" + this.target + ", watched=" + this.watched + "]";
    }

    public String toString() {
        return "PathPair [target=" + this.target + ", watched=" + this.watched + "]";
    }
}

