/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.annotation.handler.PluginHandler;
import org.hotswap.agent.annotation.handler.WatchEventCommand;
import org.hotswap.agent.annotation.handler.WatchEventDTO;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;

public class WatchHandler<T extends Annotation>
implements PluginHandler<T> {
    private static AgentLogger LOGGER = AgentLogger.getLogger(WatchHandler.class);
    protected PluginManager pluginManager;

    public WatchHandler(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean initField(PluginAnnotation<T> pluginAnnotation) {
        throw new IllegalAccessError("@OnResourceFileEvent annotation not allowed on fields.");
    }

    @Override
    public boolean initMethod(PluginAnnotation<T> pluginAnnotation) {
        LOGGER.debug("Init for method " + pluginAnnotation.getMethod(), new Object[0]);
        ClassLoader classLoader = this.pluginManager.getPluginRegistry().getAppClassLoader(pluginAnnotation.getPlugin());
        try {
            this.registerResources(pluginAnnotation, classLoader);
        }
        catch (IOException e) {
            LOGGER.error("Unable to register resources for annotation {} on method {} class {}", e, pluginAnnotation.getAnnotation(), pluginAnnotation.getMethod().getName(), pluginAnnotation.getMethod().getDeclaringClass().getName());
            return false;
        }
        return true;
    }

    private void registerResources(PluginAnnotation<T> pluginAnnotation, ClassLoader classLoader) throws IOException {
        T annot = pluginAnnotation.getAnnotation();
        WatchEventDTO watchEventDTO = WatchEventDTO.parse(annot);
        String path = watchEventDTO.getPath();
        if (path == null || path.equals(".") || path.equals("/")) {
            path = "";
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        Enumeration<URL> en = classLoader.getResources(path);
        while (en.hasMoreElements()) {
            try {
                URI uri = en.nextElement().toURI();
                try {
                    new File(uri);
                }
                catch (Exception e) {
                    LOGGER.trace("Skipping uri {}, not a local file.", uri);
                    continue;
                }
                LOGGER.debug("Registering resource listener on classpath URI {}", uri);
                this.registerResourceListener(pluginAnnotation, watchEventDTO, classLoader, uri);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Unable convert root resource path URL to URI", e, new Object[0]);
            }
        }
        if (!watchEventDTO.isClassFileEvent()) {
            for (URL url : this.pluginManager.getPluginConfiguration(classLoader).getWatchResources()) {
                try {
                    Path watchResourcePath = Paths.get(url.toURI());
                    Path pathInWatchResource = watchResourcePath.resolve(path);
                    if (!pathInWatchResource.toFile().exists()) continue;
                    LOGGER.debug("Registering resource listener on watchResources URI {}", pathInWatchResource.toUri());
                    this.registerResourceListener(pluginAnnotation, watchEventDTO, classLoader, pathInWatchResource.toUri());
                }
                catch (URISyntaxException e) {
                    LOGGER.error("Unable convert watch resource path URL {} to URI", e, url);
                }
            }
        }
    }

    private void registerResourceListener(final PluginAnnotation<T> pluginAnnotation, final WatchEventDTO watchEventDTO, final ClassLoader classLoader, URI uri) throws IOException {
        this.pluginManager.getWatcher().addEventListener(classLoader, uri, new WatchEventListener(){

            @Override
            public void onEvent(WatchFileEvent event) {
                WatchEventCommand command = WatchEventCommand.createCmdForEvent(pluginAnnotation, event, classLoader);
                if (command != null) {
                    WatchHandler.this.pluginManager.getScheduler().scheduleCommand(command, watchEventDTO.getTimeout());
                    LOGGER.trace("Resource changed {}", event);
                }
            }
        });
    }
}

