/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.hotswap.agent.HotswapAgent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.config.LogConfigurationHelper;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.HotswapProperties;
import org.hotswap.agent.util.classloader.HotswapAgentClassLoaderExt;
import org.hotswap.agent.util.classloader.URLClassPathHelper;

public class PluginConfiguration {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PluginConfiguration.class);
    private static final String PLUGIN_CONFIGURATION = "hotswap-agent.properties";
    private static final String INCLUDED_CLASS_LOADERS_KEY = "includedClassLoaderPatterns";
    private static final String EXCLUDED_CLASS_LOADERS_KEY = "excludedClassLoaderPatterns";
    Properties properties = new HotswapProperties();
    PluginConfiguration parent;
    final ClassLoader classLoader;
    URL configurationURL;
    boolean containsPropertyFileDirectly = false;

    public PluginConfiguration(ClassLoader classLoader) {
        this(null, classLoader);
    }

    public PluginConfiguration(PluginConfiguration parent, ClassLoader classLoader) {
        this(parent, classLoader, true);
    }

    public PluginConfiguration(PluginConfiguration parent, ClassLoader classLoader, boolean init) {
        this.parent = parent;
        this.classLoader = classLoader;
        this.loadConfigurationFile();
        if (init) {
            this.init();
        }
    }

    private void loadConfigurationFile() {
        try {
            String externalPropertiesFile = HotswapAgent.getExternalPropertiesFile();
            if (externalPropertiesFile != null) {
                this.configurationURL = PluginConfiguration.resourceNameToURL(externalPropertiesFile);
                this.properties.load(this.configurationURL.openStream());
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while loading external properties file " + this.configurationURL, e, new Object[0]);
        }
        if (this.parent == null) {
            this.configurationURL = this.classLoader == null ? ClassLoader.getSystemResource(PLUGIN_CONFIGURATION) : this.classLoader.getResource(PLUGIN_CONFIGURATION);
            try {
                if (this.configurationURL != null) {
                    this.containsPropertyFileDirectly = true;
                    this.properties.load(this.configurationURL.openStream());
                }
                System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put(key, value)));
            }
            catch (Exception e) {
                LOGGER.error("Error while loading 'hotswap-agent.properties' from base URL " + this.configurationURL, e, new Object[0]);
            }
        } else {
            try {
                Enumeration<URL> urls = null;
                if (this.classLoader != null) {
                    urls = this.classLoader.getResources(PLUGIN_CONFIGURATION);
                }
                if (urls == null) {
                    urls = ClassLoader.getSystemResources(PLUGIN_CONFIGURATION);
                }
                while (urls.hasMoreElements()) {
                    Enumeration<URL> parentUrls;
                    URL url = urls.nextElement();
                    boolean found = false;
                    ClassLoader parentClassLoader = this.parent.getClassLoader();
                    Enumeration<URL> enumeration = parentUrls = parentClassLoader == null ? ClassLoader.getSystemResources(PLUGIN_CONFIGURATION) : parentClassLoader.getResources(PLUGIN_CONFIGURATION);
                    while (parentUrls.hasMoreElements()) {
                        if (!url.equals(parentUrls.nextElement())) continue;
                        found = true;
                    }
                    if (found) continue;
                    this.configurationURL = url;
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while loading 'hotswap-agent.properties' from URL " + this.configurationURL, e, new Object[0]);
            }
            if (this.configurationURL == null) {
                this.configurationURL = this.parent.configurationURL;
                LOGGER.debug("Classloader does not contain 'hotswap-agent.properties', using parent file '{}'", this.parent.configurationURL);
            } else {
                LOGGER.debug("Classloader contains 'hotswap-agent.properties' at location '{}'", this.configurationURL);
                this.containsPropertyFileDirectly = true;
            }
            try {
                if (this.configurationURL != null) {
                    this.properties.load(this.configurationURL.openStream());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while loading 'hotswap-agent.properties' from URL " + this.configurationURL, e, new Object[0]);
            }
        }
    }

    protected void init() {
        LogConfigurationHelper.configureLog(this.properties);
        this.initPluginPackage();
        this.checkProperties();
        this.initIncludedClassLoaderPatterns();
        this.initExcludedClassLoaderPatterns();
        this.initExtraClassPath();
    }

    private void initPluginPackage() {
        if (this.properties.containsKey("pluginPackages")) {
            String pluginPackages = this.properties.getProperty("pluginPackages");
            for (String pluginPackage : pluginPackages.split(",")) {
                PluginManager.getInstance().getPluginRegistry().scanPlugins(this.getClassLoader(), pluginPackage);
            }
        }
    }

    private void checkProperties() {
        if (this.properties != null && this.properties.containsKey(INCLUDED_CLASS_LOADERS_KEY) && this.properties.containsKey(EXCLUDED_CLASS_LOADERS_KEY)) {
            throw new IllegalArgumentException("includedClassLoaderPatterns, excludedClassLoaderPatterns inhotswap-agent.properties are exclusive to each other. You cannot configure both options");
        }
    }

    private void initExtraClassPath() {
        Object[] extraClassPath = this.getExtraClasspath();
        if (extraClassPath.length > 0 && !this.checkExcluded()) {
            if (this.classLoader instanceof HotswapAgentClassLoaderExt) {
                ((HotswapAgentClassLoaderExt)((Object)this.classLoader)).$$ha$setExtraClassPath((URL[])extraClassPath);
            } else if (URLClassPathHelper.isApplicable(this.classLoader)) {
                URLClassPathHelper.prependClassPath(this.classLoader, (URL[])extraClassPath);
            } else {
                LOGGER.debug("Unable to set extraClasspath to {} on classLoader {}. Only classLoader with 'ucp' field present is supported.\n*** extraClasspath configuration property will not be handled on JVM level ***", Arrays.toString(extraClassPath), this.classLoader);
            }
        }
    }

    private void initIncludedClassLoaderPatterns() {
        if (this.properties != null && this.properties.containsKey(INCLUDED_CLASS_LOADERS_KEY)) {
            ArrayList<Pattern> includedClassLoaderPatterns = new ArrayList<Pattern>();
            for (String pattern : this.properties.getProperty(INCLUDED_CLASS_LOADERS_KEY).split(",")) {
                includedClassLoaderPatterns.add(Pattern.compile(pattern));
            }
            PluginManager.getInstance().getHotswapTransformer().setIncludedClassLoaderPatterns(includedClassLoaderPatterns);
        }
    }

    private void initExcludedClassLoaderPatterns() {
        if (this.properties != null && this.properties.containsKey(EXCLUDED_CLASS_LOADERS_KEY)) {
            ArrayList<Pattern> excludedClassLoaderPatterns = new ArrayList<Pattern>();
            for (String pattern : this.properties.getProperty(EXCLUDED_CLASS_LOADERS_KEY).split(",")) {
                excludedClassLoaderPatterns.add(Pattern.compile(pattern));
            }
            PluginManager.getInstance().getHotswapTransformer().setExcludedClassLoaderPatterns(excludedClassLoaderPatterns);
        }
    }

    private boolean checkExcluded() {
        if (PluginManager.getInstance().getHotswapTransformer().getIncludedClassLoaderPatterns() != null) {
            for (Pattern pattern : PluginManager.getInstance().getHotswapTransformer().getIncludedClassLoaderPatterns()) {
                if (!pattern.matcher(this.classLoader.getClass().getName()).matches()) continue;
                return false;
            }
            return true;
        }
        if (PluginManager.getInstance().getHotswapTransformer().getExcludedClassLoaderPatterns() != null) {
            for (Pattern pattern : PluginManager.getInstance().getHotswapTransformer().getExcludedClassLoaderPatterns()) {
                if (!pattern.matcher(this.classLoader.getClass().getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public String getProperty(String property) {
        if (this.properties.containsKey(property)) {
            return this.properties.getProperty(property);
        }
        if (this.parent != null) {
            return this.parent.getProperty(property);
        }
        return null;
    }

    public String getProperty(String property, String defaultValue) {
        String value = this.getProperty(property);
        return value != null ? value : defaultValue;
    }

    public boolean getPropertyBoolean(String property) {
        if (this.properties.containsKey(property)) {
            return Boolean.valueOf(this.properties.getProperty(property));
        }
        if (this.parent != null) {
            return this.parent.getPropertyBoolean(property);
        }
        return false;
    }

    public URL[] getExtraClasspath() {
        return this.convertToURL(this.getProperty("extraClasspath"));
    }

    public URL[] getWatchResources() {
        return this.convertToURL(this.getProperty("watchResources"));
    }

    public String[] getBasePackagePrefixes() {
        String basePackagePrefix = this.getProperty("spring.basePackagePrefix");
        if (basePackagePrefix != null) {
            return basePackagePrefix.split(",");
        }
        return null;
    }

    public URL[] getWebappDir() {
        return this.convertToURL(this.getProperty("webappDir"));
    }

    public List<String> getDisabledPlugins() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String disabledPlugin : this.getProperty("disabledPlugins", "").split(",")) {
            ret.add(disabledPlugin.trim());
        }
        return ret;
    }

    public boolean isDisabledPlugin(String pluginName) {
        return HotswapAgent.isPluginDisabled(pluginName) || this.getDisabledPlugins().contains(pluginName);
    }

    public boolean isDisabledPlugin(Class<?> pluginClass) {
        Plugin pluginAnnotation = pluginClass.getAnnotation(Plugin.class);
        return this.isDisabledPlugin(pluginAnnotation.name());
    }

    private URL[] convertToURL(String resources) {
        ArrayList<URL> ret = new ArrayList<URL>();
        if (resources != null) {
            StringTokenizer tokenizer = new StringTokenizer(resources, ",;");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken().trim();
                try {
                    ret.add(PluginConfiguration.resourceNameToURL(name));
                }
                catch (Exception e) {
                    LOGGER.error("Invalid configuration value: '{}' is not a valid URL or path and will be skipped.", name, e);
                }
            }
        }
        return ret.toArray(new URL[ret.size()]);
    }

    private static URL resourceNameToURL(String resource) throws Exception {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            if (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            File file = new File(resource).getCanonicalFile();
            return file.toURI().toURL();
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean containsPropertyFile() {
        return this.containsPropertyFileDirectly;
    }
}

