/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hotswap.agent.logging.AgentLogger;

public class AgentLoggerHandler {
    PrintStream outputStream;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    public void setPrintStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    protected void printMessage(String message) {
        String log = "HOTSWAP AGENT: " + this.sdf.format(new Date()) + " " + message;
        System.out.println(log);
        if (this.outputStream != null) {
            this.outputStream.println(log);
        }
    }

    public void print(Class clazz, AgentLogger.Level level, String message, Throwable throwable, Object ... args) {
        String messageWithArgs = message;
        for (Object arg : args) {
            int index = messageWithArgs.indexOf("{}");
            if (index < 0) continue;
            messageWithArgs = messageWithArgs.substring(0, index) + String.valueOf(arg) + messageWithArgs.substring(index + 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((Object)level);
        stringBuffer.append(" (");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(") - ");
        stringBuffer.append(messageWithArgs);
        if (throwable != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.formatErrorTrace(throwable));
        }
        this.printMessage(stringBuffer.toString());
    }

    private String formatErrorTrace(Throwable throwable) {
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.sdf = new SimpleDateFormat(dateTimeFormat);
    }
}

