/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.signature;

import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.signature.ClassSignatureElement;
import org.hotswap.agent.util.signature.CtClassSignature;
import org.hotswap.agent.util.signature.JavaClassSignature;

public class ClassSignatureComparerHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassSignatureComparerHelper.class);

    public static String getCtClassSignature(CtClass ctClass, ClassSignatureElement[] signatureElements) throws Exception {
        CtClassSignature signature = new CtClassSignature(ctClass);
        signature.addSignatureElements(signatureElements);
        return signature.getValue();
    }

    public static String getJavaClassSignature(Class<?> clazz, ClassSignatureElement[] signatureElements) throws Exception {
        JavaClassSignature signature = new JavaClassSignature(clazz);
        signature.addSignatureElements(signatureElements);
        return signature.getValue();
    }

    public static boolean isDifferent(CtClass ctClass, Class<?> clazz, ClassSignatureElement[] signatureElements) {
        try {
            String sig1 = ClassSignatureComparerHelper.getCtClassSignature(ctClass, signatureElements);
            String sig2 = ClassSignatureComparerHelper.getJavaClassSignature(clazz, signatureElements);
            return !sig1.equals(sig2);
        }
        catch (Exception e) {
            LOGGER.error("Error reading signature", e, new Object[0]);
            return false;
        }
    }

    public static boolean isDifferent(Class<?> clazz1, Class<?> clazz2, ClassSignatureElement[] signatureElements) {
        try {
            String sig1 = ClassSignatureComparerHelper.getJavaClassSignature(clazz1, signatureElements);
            String sig2 = ClassSignatureComparerHelper.getJavaClassSignature(clazz2, signatureElements);
            return !sig1.equals(sig2);
        }
        catch (Exception e) {
            LOGGER.error("Error reading signature", e, new Object[0]);
            return false;
        }
    }

    public static boolean isPoolClassDifferent(Class<?> clazz, ClassPool cp, ClassSignatureElement[] signatureElements) {
        try {
            return ClassSignatureComparerHelper.isDifferent(cp.get(clazz.getName()), clazz, signatureElements);
        }
        catch (NotFoundException e) {
            LOGGER.error("Class not found ", e, new Object[0]);
            return false;
        }
    }
}

