/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.signature;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMember;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.util.signature.ClassSignatureBase;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public class CtClassSignature
extends ClassSignatureBase {
    private CtClass ctClass;

    public CtClassSignature(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    @Override
    public String getValue() throws Exception {
        String superclassName;
        ArrayList<String> strings = new ArrayList<String>();
        if (this.hasElement(ClassSignatureElement.METHOD)) {
            boolean usePrivateMethod = this.hasElement(ClassSignatureElement.METHOD_PRIVATE);
            int useStaticMethod = this.hasElement(ClassSignatureElement.METHOD_STATIC);
            CtMember[] ctMemberArray = this.ctClass.getDeclaredMethods();
            int n = ctMemberArray.length;
            for (int i = 0; i < n; ++i) {
                CtMethod ctMethod = ctMemberArray[i];
                if (!usePrivateMethod && Modifier.isPrivate(ctMethod.getModifiers()) || useStaticMethod == 0 && Modifier.isStatic(ctMethod.getModifiers()) || ctMethod.getName().startsWith("$SWITCH_TABLE$")) continue;
                strings.add(this.getMethodString(ctMethod));
            }
        }
        if (this.hasElement(ClassSignatureElement.CONSTRUCTOR)) {
            boolean usePrivateConstructor = this.hasElement(ClassSignatureElement.CONSTRUCTOR_PRIVATE);
            for (CtConstructor method : this.ctClass.getDeclaredConstructors()) {
                if (!usePrivateConstructor && Modifier.isPrivate(method.getModifiers())) continue;
                strings.add(this.getConstructorString(method));
            }
        }
        if (this.hasElement(ClassSignatureElement.CLASS_ANNOTATION)) {
            strings.add(this.annotationToString(this.ctClass.getAvailableAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.INTERFACES)) {
            for (CtClass iClass : this.ctClass.getInterfaces()) {
                strings.add(iClass.getName());
            }
        }
        if (this.hasElement(ClassSignatureElement.SUPER_CLASS) && (superclassName = this.ctClass.getSuperclassName()) != null && !superclassName.equals(Object.class.getName())) {
            strings.add(superclassName);
        }
        if (this.hasElement(ClassSignatureElement.FIELD)) {
            boolean useStaticField = this.hasElement(ClassSignatureElement.FIELD_STATIC);
            boolean useFieldAnnotation = this.hasElement(ClassSignatureElement.FIELD_ANNOTATION);
            for (CtMember ctMember : this.ctClass.getDeclaredFields()) {
                if (!useStaticField && Modifier.isStatic(((CtField)ctMember).getModifiers()) || ((CtField)ctMember).getName().startsWith("$SWITCH_TABLE$")) continue;
                String fieldSignature = ((CtField)ctMember).getType().getName() + " " + ((CtField)ctMember).getName();
                if (useFieldAnnotation) {
                    fieldSignature = fieldSignature + this.annotationToString(((CtField)ctMember).getAvailableAnnotations());
                }
                strings.add(fieldSignature + ";");
            }
        }
        Collections.sort(strings);
        StringBuilder strBuilder = new StringBuilder();
        for (String methodString : strings) {
            strBuilder.append(methodString);
        }
        return strBuilder.toString();
    }

    private String getName(CtClass ctClass) {
        return ctClass.getName();
    }

    private String getConstructorString(CtConstructor method) throws ClassNotFoundException, NotFoundException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Modifier.toString(method.getModifiers()) + " ");
        strBuilder.append(method.getDeclaringClass().getName());
        strBuilder.append(this.getParams(method.getParameterTypes()));
        if (this.hasElement(ClassSignatureElement.METHOD_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getAvailableAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_PARAM_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getAvailableParameterAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_EXCEPTION)) {
            strBuilder.append(this.toStringException(method.getExceptionTypes()));
        }
        strBuilder.append(";");
        return strBuilder.toString();
    }

    private String getMethodString(CtMethod method) throws NotFoundException, ClassNotFoundException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Modifier.toString(method.getModifiers()) + " ");
        strBuilder.append(this.getName(method.getReturnType()) + " " + method.getName());
        strBuilder.append(this.getParams(method.getParameterTypes()));
        if (this.hasElement(ClassSignatureElement.METHOD_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getAvailableAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_PARAM_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getAvailableParameterAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_EXCEPTION)) {
            strBuilder.append(this.toStringException(method.getExceptionTypes()));
        }
        strBuilder.append(";");
        return strBuilder.toString();
    }

    private String getParams(CtClass[] ctClasses) {
        StringBuilder strBuilder = new StringBuilder("(");
        boolean first = true;
        for (CtClass ctClass : ctClasses) {
            if (!first) {
                strBuilder.append(",");
            } else {
                first = false;
            }
            strBuilder.append(this.getName(ctClass));
        }
        strBuilder.append(")");
        return strBuilder.toString();
    }

    private String toStringException(CtClass[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        a = this.sort(a);
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append("class " + a[i].getName());
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private CtClass[] sort(CtClass[] a) {
        a = Arrays.copyOf(a, a.length);
        Arrays.sort(a, CtClassComparator.INSTANCE);
        return a;
    }

    private static class CtClassComparator
    implements Comparator<CtClass> {
        public static final CtClassComparator INSTANCE = new CtClassComparator();

        private CtClassComparator() {
        }

        @Override
        public int compare(CtClass o1, CtClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

