/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.annotation.handler.InitHandler;
import org.hotswap.agent.annotation.handler.OnClassLoadedHandler;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.annotation.handler.PluginHandler;
import org.hotswap.agent.annotation.handler.WatchHandler;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;

public class AnnotationProcessor {
    private static AgentLogger LOGGER = AgentLogger.getLogger(AnnotationProcessor.class);
    protected PluginManager pluginManager;
    protected Map<Class<? extends Annotation>, PluginHandler> handlers = new HashMap<Class<? extends Annotation>, PluginHandler>();

    public AnnotationProcessor(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.init(pluginManager);
    }

    public void init(PluginManager pluginManager) {
        this.addAnnotationHandler(Init.class, new InitHandler(pluginManager));
        this.addAnnotationHandler(OnClassLoadEvent.class, new OnClassLoadedHandler(pluginManager));
        this.addAnnotationHandler(OnClassFileEvent.class, new WatchHandler(pluginManager));
        this.addAnnotationHandler(OnResourceFileEvent.class, new WatchHandler(pluginManager));
    }

    public void addAnnotationHandler(Class<? extends Annotation> annotation, PluginHandler handler) {
        this.handlers.put(annotation, handler);
    }

    public boolean processAnnotations(Class processClass, Class pluginClass) {
        try {
            for (Field field : processClass.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || this.processFieldAnnotations(null, field, pluginClass)) continue;
                return false;
            }
            for (AccessibleObject accessibleObject : processClass.getDeclaredMethods()) {
                if (!Modifier.isStatic(((Method)accessibleObject).getModifiers()) || this.processMethodAnnotations(null, (Method)accessibleObject, pluginClass)) continue;
                return false;
            }
            for (Annotation annotation : processClass.getDeclaredAnnotations()) {
                if (!(annotation instanceof Plugin)) continue;
                for (Class<?> supportClass : ((Plugin)annotation).supportClass()) {
                    this.processAnnotations(supportClass, pluginClass);
                }
            }
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("Unable to process plugin annotations '{}'", e, pluginClass);
            return false;
        }
    }

    public boolean processAnnotations(Object plugin) {
        LOGGER.debug("Processing annotations for plugin '" + plugin + "'.", new Object[0]);
        Class<?> pluginClass = plugin.getClass();
        for (Field field : pluginClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || this.processFieldAnnotations(plugin, field, pluginClass)) continue;
            return false;
        }
        for (AccessibleObject accessibleObject : pluginClass.getDeclaredMethods()) {
            if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || this.processMethodAnnotations(plugin, (Method)accessibleObject, pluginClass)) continue;
            return false;
        }
        return true;
    }

    private boolean processFieldAnnotations(Object plugin, Field field, Class pluginClass) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            for (Class<? extends Annotation> handlerAnnotation : this.handlers.keySet()) {
                if (!annotation.annotationType().equals(handlerAnnotation)) continue;
                PluginAnnotation<Annotation> pluginAnnotation = new PluginAnnotation<Annotation>(pluginClass, plugin, annotation, field);
                if (this.handlers.get(handlerAnnotation).initField(pluginAnnotation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processMethodAnnotations(Object plugin, Method method, Class pluginClass) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            for (Class<? extends Annotation> handlerAnnotation : this.handlers.keySet()) {
                if (!annotation.annotationType().equals(handlerAnnotation)) continue;
                PluginAnnotation<Annotation> pluginAnnotation = new PluginAnnotation<Annotation>(pluginClass, plugin, annotation, method);
                if (this.handlers.get(handlerAnnotation).initMethod(pluginAnnotation)) continue;
                return false;
            }
        }
        return true;
    }
}

