/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.config;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.command.impl.SchedulerImpl;
import org.hotswap.agent.config.ClassLoaderInitListener;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginRegistry;
import org.hotswap.agent.config.ScheduledHotswapCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.HotswapTransformer;
import org.hotswap.agent.util.classloader.ClassLoaderDefineClassPatcher;
import org.hotswap.agent.watch.Watcher;
import org.hotswap.agent.watch.WatcherFactory;

public class PluginManager {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PluginManager.class);
    public static final String PLUGIN_PACKAGE = "org.hotswap.agent.plugin";
    private static PluginManager INSTANCE = new PluginManager();
    private Instrumentation instrumentation;
    private Object hotswapLock = new Object();
    ClassLoaderDefineClassPatcher classLoaderPatcher = new ClassLoaderDefineClassPatcher();
    Map<ClassLoader, PluginConfiguration> classLoaderConfigurations = new HashMap<ClassLoader, PluginConfiguration>();
    Set<ClassLoaderInitListener> classLoaderInitListeners = new HashSet<ClassLoaderInitListener>();
    private PluginRegistry pluginRegistry;
    protected HotswapTransformer hotswapTransformer = new HotswapTransformer();
    protected Watcher watcher;
    protected Scheduler scheduler;

    public static PluginManager getInstance() {
        return INSTANCE;
    }

    private PluginManager() {
        this.pluginRegistry = new PluginRegistry(this, this.classLoaderPatcher);
    }

    public Object getPlugin(String clazz, ClassLoader classLoader) {
        try {
            return this.getPlugin(Class.forName(clazz), classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Plugin class not found " + clazz, e);
        }
    }

    public <T> T getPlugin(Class<T> clazz, ClassLoader classLoader) {
        return this.pluginRegistry.getPlugin(clazz, classLoader);
    }

    public boolean isPluginInitialized(String pluginClassName, ClassLoader classLoader) {
        Class<Object> pluginClass = this.pluginRegistry.getPluginClass(pluginClassName);
        return pluginClass != null && this.pluginRegistry.hasPlugin(pluginClass, classLoader, false);
    }

    public void init(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        if (this.watcher == null) {
            try {
                this.watcher = new WatcherFactory().getWatcher();
            }
            catch (IOException e) {
                LOGGER.debug("Unable to create default watcher.", e, new Object[0]);
            }
        }
        this.watcher.run();
        if (this.scheduler == null) {
            this.scheduler = new SchedulerImpl();
        }
        this.scheduler.run();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.classLoaderConfigurations.put(classLoader, new PluginConfiguration(classLoader));
        this.pluginRegistry.scanPlugins(this.getClass().getClassLoader(), PLUGIN_PACKAGE);
        LOGGER.debug("Registering transformer ", new Object[0]);
        instrumentation.addTransformer(this.hotswapTransformer);
    }

    public void registerClassLoaderInitListener(ClassLoaderInitListener classLoaderInitListener) {
        this.classLoaderInitListeners.add(classLoaderInitListener);
        classLoaderInitListener.onInit(this.getClass().getClassLoader());
    }

    public void initClassLoader(ClassLoader classLoader) {
        this.initClassLoader(classLoader, classLoader.getClass().getProtectionDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        if (this.classLoaderConfigurations.containsKey(classLoader)) {
            return;
        }
        if (this.getClass().getClassLoader() != null && classLoader != null && classLoader.equals(this.getClass().getClassLoader().getParent())) {
            return;
        }
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            if (this.classLoaderConfigurations.containsKey(classLoader)) {
                return;
            }
            if (classLoader != null && this.classLoaderPatcher.isPatchAvailable(classLoader)) {
                this.classLoaderPatcher.patch(this.getClass().getClassLoader(), PLUGIN_PACKAGE.replace(".", "/"), classLoader, protectionDomain);
            }
            PluginConfiguration pluginConfiguration = new PluginConfiguration(this.getPluginConfiguration(this.getClass().getClassLoader()), classLoader, false);
            this.classLoaderConfigurations.put(classLoader, pluginConfiguration);
            pluginConfiguration.init();
        }
        for (ClassLoaderInitListener classLoaderInitListener : this.classLoaderInitListeners) {
            classLoaderInitListener.onInit(classLoader);
        }
    }

    public void closeClassLoader(ClassLoader classLoader) {
        this.pluginRegistry.closeClassLoader(classLoader);
        this.classLoaderConfigurations.remove(classLoader);
        this.hotswapTransformer.closeClassLoader(classLoader);
    }

    public PluginConfiguration getPluginConfiguration(ClassLoader classLoader) {
        ClassLoader loader;
        for (loader = classLoader; loader != null && !this.classLoaderConfigurations.containsKey(loader); loader = loader.getParent()) {
        }
        return this.classLoaderConfigurations.get(loader);
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void setPluginRegistry(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public HotswapTransformer getHotswapTransformer() {
        return this.hotswapTransformer;
    }

    public Watcher getWatcher() {
        return this.watcher;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hotswap(Map<Class<?>, byte[]> reloadMap) {
        if (this.instrumentation == null) {
            throw new IllegalStateException("Plugin manager is not correctly initialized - no instrumentation available.");
        }
        Map<Class<?>, byte[]> map = reloadMap;
        synchronized (map) {
            ClassDefinition[] definitions = new ClassDefinition[reloadMap.size()];
            Object[] classNames = new String[reloadMap.size()];
            int i = 0;
            for (Map.Entry<Class<?>, byte[]> entry : reloadMap.entrySet()) {
                classNames[i] = entry.getKey().getName();
                definitions[i++] = new ClassDefinition(entry.getKey(), entry.getValue());
            }
            try {
                LOGGER.reload("Reloading classes {} (autoHotswap)", Arrays.toString(classNames));
                Object object = this.hotswapLock;
                synchronized (object) {
                    this.instrumentation.redefineClasses(definitions);
                }
                LOGGER.debug("... reloaded classes {} (autoHotswap)", Arrays.toString(classNames));
            }
            catch (Exception e) {
                LOGGER.debug("... Fail to reload classes {} (autoHotswap), msg is {}", Arrays.toString(classNames), e);
                throw new IllegalStateException("Unable to redefine classes", e);
            }
            reloadMap.clear();
        }
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void scheduleHotswap(Map<Class<?>, byte[]> reloadMap, int timeout) {
        if (this.instrumentation == null) {
            throw new IllegalStateException("Plugin manager is not correctly initialized - no instrumentation available.");
        }
        this.getScheduler().scheduleCommand(new ScheduledHotswapCommand(reloadMap), timeout);
    }
}

