/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

public class WatchResourcesClassLoader
extends URLClassLoader {
    private static AgentLogger LOGGER = AgentLogger.getLogger(WatchResourcesClassLoader.class);
    Set<URL> changedUrls = new HashSet<URL>();
    boolean searchParent = true;
    ClassLoader watchResourcesClassLoader;

    public void setSearchParent(boolean searchParent) {
        this.searchParent = searchParent;
    }

    public WatchResourcesClassLoader() {
        this(false);
    }

    public WatchResourcesClassLoader(boolean searchParent) {
        super(new URL[]{}, searchParent ? WatchResourcesClassLoader.class.getClassLoader() : null);
        this.searchParent = searchParent;
    }

    public WatchResourcesClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        this.searchParent = false;
    }

    public void initExtraPath(URL[] extraPath) {
        for (URL url : extraPath) {
            this.addURL(url);
        }
    }

    public void initWatchResources(URL[] watchResources, Watcher watcher) {
        this.watchResourcesClassLoader = new UrlOnlyClassLoader(watchResources);
        for (URL resource : watchResources) {
            try {
                URI uri = resource.toURI();
                LOGGER.debug("Watching directory '{}' for changes.", uri);
                watcher.addEventListener((ClassLoader)this, uri, new WatchEventListener(){

                    @Override
                    public void onEvent(WatchFileEvent event) {
                        try {
                            if (event.isFile() || event.isDirectory()) {
                                WatchResourcesClassLoader.this.changedUrls.add(event.getURI().toURL());
                                LOGGER.trace("File '{}' changed and will be returned instead of original classloader equivalent.", event.getURI().toURL());
                            }
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error("Unexpected - cannot convert URI {} to URL.", e, event.getURI());
                        }
                    }
                });
            }
            catch (URISyntaxException e) {
                LOGGER.warning("Unable to convert watchResources URL '{}' to URI. URL is skipped.", e, resource);
            }
        }
    }

    public boolean isResourceChanged(URL url) {
        return this.changedUrls.contains(url);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (this.watchResourcesClassLoader != null && (resource = this.watchResourcesClassLoader.getResource(name)) != null && this.isResourceChanged(resource)) {
            LOGGER.trace("watchResources - using changed resource {}", name);
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        if (this.searchParent) {
            return super.getResource(name);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL resource;
        if (this.watchResourcesClassLoader != null && (resource = this.watchResourcesClassLoader.getResource(name)) != null && this.isResourceChanged(resource)) {
            LOGGER.trace("watchResources - using changed resource {}", name);
            Vector<URL> res = new Vector<URL>();
            res.add(resource);
            return res.elements();
        }
        if (this.findResources(name).hasMoreElements()) {
            return this.findResources(name);
        }
        return super.getResources(name);
    }

    public String getClasspath() {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            Method m = parent.getClass().getMethod("getClasspath", new Class[0]);
            if (m == null) {
                return null;
            }
            Object o = m.invoke((Object)parent, new Object[0]);
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.debug("getClasspath not supported on parent classloader.", new Object[0]);
            return null;
        }
    }

    public static class UrlOnlyClassLoader
    extends URLClassLoader {
        public UrlOnlyClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public URL getResource(String name) {
            return this.findResource(name);
        }
    }
}

