/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.signature;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hotswap.agent.javassist.bytecode.Descriptor;
import org.hotswap.agent.util.signature.ClassSignatureBase;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public class JavaClassSignature
extends ClassSignatureBase {
    private Class<?> clazz;

    public JavaClassSignature(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getValue() throws Exception {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.hasElement(ClassSignatureElement.METHOD)) {
            boolean usePrivateMethod = this.hasElement(ClassSignatureElement.METHOD_PRIVATE);
            int useStaticMethod = this.hasElement(ClassSignatureElement.METHOD_STATIC);
            AccessibleObject[] accessibleObjectArray = this.clazz.getDeclaredMethods();
            int n = accessibleObjectArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = accessibleObjectArray[i];
                if (!usePrivateMethod && Modifier.isPrivate(method.getModifiers()) || useStaticMethod == 0 && Modifier.isStatic(method.getModifiers()) || method.getName().startsWith("$SWITCH_TABLE$")) continue;
                strings.add(this.getMethodString(method));
            }
        }
        if (this.hasElement(ClassSignatureElement.CONSTRUCTOR)) {
            boolean usePrivateConstructor = this.hasElement(ClassSignatureElement.CONSTRUCTOR_PRIVATE);
            for (Constructor<?> method : this.clazz.getDeclaredConstructors()) {
                if (!usePrivateConstructor && Modifier.isPrivate(method.getModifiers())) continue;
                strings.add(this.getConstructorString(method));
            }
        }
        if (this.hasElement(ClassSignatureElement.CLASS_ANNOTATION)) {
            strings.add(this.annotationToString(this.clazz.getAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.INTERFACES)) {
            for (Class<?> iClass : this.clazz.getInterfaces()) {
                strings.add(iClass.getName());
            }
        }
        if (this.hasElement(ClassSignatureElement.SUPER_CLASS) && this.clazz.getSuperclass() != null && !this.clazz.getSuperclass().getName().equals(Object.class.getName())) {
            strings.add(this.clazz.getSuperclass().getName());
        }
        if (this.hasElement(ClassSignatureElement.FIELD)) {
            boolean useStaticField = this.hasElement(ClassSignatureElement.FIELD_STATIC);
            boolean useFieldAnnotation = this.hasElement(ClassSignatureElement.FIELD_ANNOTATION);
            for (AccessibleObject accessibleObject : this.clazz.getDeclaredFields()) {
                if (!useStaticField && Modifier.isStatic(((Field)accessibleObject).getModifiers()) || ((Field)accessibleObject).getName().startsWith("$SWITCH_TABLE$")) continue;
                String fieldSignature = ((Field)accessibleObject).getType().getName() + " " + ((Field)accessibleObject).getName();
                if (useFieldAnnotation) {
                    fieldSignature = fieldSignature + this.annotationToString(accessibleObject.getAnnotations());
                }
                strings.add(fieldSignature + ";");
            }
        }
        Collections.sort(strings);
        StringBuilder strBuilder = new StringBuilder();
        for (String methodString : strings) {
            strBuilder.append(methodString);
        }
        return strBuilder.toString();
    }

    private String getConstructorString(Constructor<?> method) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Modifier.toString(method.getModifiers()) + " ");
        strBuilder.append(method.getName());
        strBuilder.append(this.getParams(method.getParameterTypes()));
        if (this.hasElement(ClassSignatureElement.METHOD_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getDeclaredAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_PARAM_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getParameterAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_EXCEPTION)) {
            strBuilder.append(Arrays.toString(this.sort(method.getExceptionTypes())));
        }
        strBuilder.append(";");
        return strBuilder.toString();
    }

    private String getMethodString(Method method) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Modifier.toString(method.getModifiers()) + " ");
        strBuilder.append(this.getName(method.getReturnType()) + " " + method.getName());
        strBuilder.append(this.getParams(method.getParameterTypes()));
        if (this.hasElement(ClassSignatureElement.METHOD_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getDeclaredAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_PARAM_ANNOTATION)) {
            strBuilder.append(this.annotationToString(method.getParameterAnnotations()));
        }
        if (this.hasElement(ClassSignatureElement.METHOD_EXCEPTION)) {
            strBuilder.append(Arrays.toString(this.sort(method.getExceptionTypes())));
        }
        strBuilder.append(";");
        return strBuilder.toString();
    }

    private <T> T[] sort(T[] a) {
        a = Arrays.copyOf(a, a.length);
        Arrays.sort(a, ClassSignatureBase.ToStringComparator.INSTANCE);
        return a;
    }

    private String getParams(Class<?>[] parameterTypes) {
        StringBuilder strB = new StringBuilder("(");
        boolean first = true;
        for (Class<?> ctClass : parameterTypes) {
            if (!first) {
                strB.append(",");
            } else {
                first = false;
            }
            strB.append(this.getName(ctClass));
        }
        strB.append(")");
        return strB.toString();
    }

    private String getName(Class<?> ctClass) {
        if (ctClass.isArray()) {
            return Descriptor.toString(ctClass.getName());
        }
        return ctClass.getName();
    }
}

