/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import org.hotswap.agent.watch.HotswapAgentWatchEvent;
import org.hotswap.agent.watch.nio.AbstractNIO2Watcher;

public class WatcherNIO2
extends AbstractNIO2Watcher {
    private static final WatchEvent.Modifier HIGH = WatcherNIO2.getWatchEventModifier("com.sun.nio.file.SensitivityWatchEventModifier", "HIGH");

    @Override
    protected void registerAll(Path dir, final boolean fromCreateEvent) throws IOException {
        this.LOGGER.debug("Registering directory  {}", dir);
        Files.walkFileTree(dir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (fromCreateEvent) {
                    WatcherNIO2.this.sendFakeCreateEvents(dir);
                }
                WatcherNIO2.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void sendFakeCreateEvents(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                if (!Files.isRegularFile(entry, new LinkOption[0])) continue;
                String name = entry.getFileName().toString();
                HotswapAgentWatchEvent<String> ev = new HotswapAgentWatchEvent<String>(StandardWatchEventKinds.ENTRY_CREATE, name);
                this.LOGGER.debug("Fake watch event '{}' on '{}' --> {}", ev.kind().name(), entry, name);
                this.dispatcher.add(ev, entry);
            }
        }
        catch (IOException e) {
            this.LOGGER.warning("Unable to send fake create events for directory {}", e, dir);
        }
    }

    private void register(Path dir) throws IOException {
        WatchKey key = HIGH == null ? dir.register(this.watcher, KINDS) : dir.register(this.watcher, KINDS, HIGH);
        this.keys.put(key, dir);
    }
}

