/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cxf.jaxrs;

import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cxf.jaxrs.ClassResourceInfoProxyHelper;

public class CxfJAXRSCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CxfJAXRSCommand.class);
    private ClassLoader classLoader;
    private ClassResourceInfo criProxy;

    public void setupCmd(ClassLoader classLoader, Object criProxy) {
        this.classLoader = classLoader;
        this.criProxy = (ClassResourceInfo)criProxy;
    }

    public void executeCommand() {
        LOGGER.debug("Reloading service={}, in classLoader={}", new Object[]{this.criProxy.getServiceClass(), this.classLoader});
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ClassResourceInfoProxyHelper.reloadClassResourceInfo(this.criProxy);
            LOGGER.info("Resource class {} reloaded.", new Object[]{this.criProxy.getResourceClass().getName()});
        }
        catch (Exception e) {
            LOGGER.error("Could not reload JAXRS service class {}", (Throwable)e, new Object[]{this.criProxy.getServiceClass()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
        result = 31 * result + (this.criProxy == null ? 0 : this.criProxy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CxfJAXRSCommand other = (CxfJAXRSCommand)((Object)obj);
        if (this.classLoader == null ? other.classLoader != null : !this.classLoader.equals(other.classLoader)) {
            return false;
        }
        return !(this.criProxy == null ? other.criProxy != null : !this.criProxy.equals(other.criProxy));
    }

    public String toString() {
        return "CxfJAXRSCommand[classLoader=" + this.classLoader + ", service class =" + this.criProxy.getServiceClass() + "]";
    }
}

