/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cxf.jaxrs;

import java.lang.ref.WeakReference;
import java.util.List;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.cdi.HaCdiExtraContext;
import org.hotswap.agent.util.ReflectionHelper;

public class HaCdiExtraCxfContext
implements HaCdiExtraContext {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HaCdiExtraCxfContext.class);
    WeakReference<Object> pluginReference;

    public static void registerExtraContext(Object pluginInstance) {
        HaCdiExtraCxfContext context = new HaCdiExtraCxfContext(pluginInstance);
        HaCdiCommons.registerExtraContext((HaCdiExtraContext)context);
    }

    HaCdiExtraCxfContext(Object plugin) {
        this.pluginReference = new WeakReference<Object>(plugin);
    }

    public boolean containsBeanInstances(Class<?> beanClass) {
        Object plugin = this.pluginReference.get();
        if (plugin != null) {
            try {
                return (Boolean)ReflectionHelper.invoke(plugin, plugin.getClass(), (String)"containsServiceInstance", (Class[])new Class[]{Class.class}, (Object[])new Object[]{beanClass});
            }
            catch (Exception e) {
                LOGGER.error("containsBeanInstances() exception {}", (Throwable)e, new Object[0]);
            }
        }
        return false;
    }

    public List<Object> getBeanInstances(Class<?> beanClass) {
        Object plugin = this.pluginReference.get();
        if (plugin != null) {
            try {
                return (List)ReflectionHelper.invoke(plugin, plugin.getClass(), (String)"getServiceInstances", (Class[])new Class[]{Class.class}, (Object[])new Object[]{beanClass});
            }
            catch (Exception e) {
                LOGGER.error("getBeanInstances() exception {}", (Throwable)e, new Object[0]);
            }
        }
        return null;
    }
}

