/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cxf.jaxrs;

import java.lang.reflect.Method;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.javassist.util.proxy.MethodFilter;
import org.hotswap.agent.javassist.util.proxy.MethodHandler;
import org.hotswap.agent.javassist.util.proxy.Proxy;
import org.hotswap.agent.javassist.util.proxy.ProxyFactory;
import org.hotswap.agent.javassist.util.proxy.ProxyObject;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cxf.jaxrs.CxfJAXRSPlugin;
import org.hotswap.agent.util.ReflectionHelper;

public class ClassResourceInfoProxyHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassResourceInfoProxyHelper.class);
    private static Class<?> classResourceInfoProxyClass = null;
    private static final ThreadLocal<Boolean> DISABLE_PROXY_GENERATION = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private static synchronized void createProxyClass(ClassResourceInfo cri) {
        if (classResourceInfoProxyClass == null) {
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(cri.getClass());
            f.setFilter(new MethodFilter(){

                public boolean isHandled(Method m) {
                    return true;
                }
            });
            classResourceInfoProxyClass = f.createClass();
        }
    }

    public static ClassResourceInfo createProxy(ClassResourceInfo classResourceInfo, Class<?>[] generatorTypes, Object[] generatorParams) {
        if (!DISABLE_PROXY_GENERATION.get().booleanValue()) {
            try {
                ClassResourceInfoProxyHelper.createProxyClass(classResourceInfo);
                ClassResourceInfo result = (ClassResourceInfo)classResourceInfoProxyClass.newInstance();
                CriProxyMethodHandler methodHandler = new CriProxyMethodHandler(result, generatorTypes, generatorParams);
                ((Proxy)result).setHandler((MethodHandler)methodHandler);
                methodHandler.delegate = classResourceInfo;
                methodHandler.generatorTypes = generatorTypes;
                methodHandler.generatorParams = generatorParams;
                return result;
            }
            catch (Exception e) {
                LOGGER.error("Unable to create ClassResourceInfo proxy for {}", (Throwable)e, new Object[]{classResourceInfo});
            }
        }
        return classResourceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadClassResourceInfo(ClassResourceInfo classResourceInfoProxy) {
        try {
            DISABLE_PROXY_GENERATION.set(true);
            CriProxyMethodHandler criMethodHandler = (CriProxyMethodHandler)((ProxyObject)classResourceInfoProxy).getHandler();
            ClassResourceInfo newClassResourceInfo = (ClassResourceInfo)ReflectionHelper.invoke(null, ResourceUtils.class, (String)"createClassResourceInfo", (Class[])criMethodHandler.generatorTypes, (Object[])criMethodHandler.generatorParams);
            ClassResourceInfo oldClassResourceInfo = criMethodHandler.delegate;
            ResourceProvider resourceProvider = oldClassResourceInfo.getResourceProvider();
            ClassResourceInfoProxyHelper.updateResourceProvider(resourceProvider);
            newClassResourceInfo.setResourceProvider(resourceProvider);
            criMethodHandler.delegate = newClassResourceInfo;
        }
        catch (Exception e) {
            LOGGER.error("reloadClassResourceInfo() exception {}", new Object[]{e.getMessage()});
        }
        finally {
            DISABLE_PROXY_GENERATION.remove();
        }
    }

    private static void updateResourceProvider(ResourceProvider resourceProvider) {
        if (resourceProvider.getClass().getName().equals("org.apache.cxf.jaxrs.spring.SpringResourceFactory")) {
            try {
                ReflectionHelper.invoke((Object)resourceProvider, resourceProvider.getClass(), (String)"clearSingletonInstance", null, null);
            }
            catch (Exception e) {
                LOGGER.error("updateResourceProvider() clearSingletonInstance failed. {}", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class CriProxyMethodHandler
    implements MethodHandler {
        ClassResourceInfo delegate;
        Object[] generatorParams;
        Class<?>[] generatorTypes;

        public CriProxyMethodHandler(ClassResourceInfo delegate, Class<?>[] generatorTypes, Object[] generatorParams) {
            this.generatorTypes = generatorTypes;
        }

        public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
            if (method.getName() == "setResourceProvider" && args != null && args[0] != null && args[0] instanceof SingletonResourceProvider) {
                try {
                    SingletonResourceProvider resourceProvider = (SingletonResourceProvider)args[0];
                    ClassLoader pluginClassLoader = this.delegate.getServiceClass().getClassLoader();
                    Object pluginInstance = PluginManager.getInstance().getPlugin(CxfJAXRSPlugin.class.getName(), pluginClassLoader);
                    if (pluginInstance != null) {
                        ReflectionHelper.invoke((Object)pluginInstance, pluginInstance.getClass(), (String)"registerServiceInstance", (Class[])new Class[]{Object.class}, (Object[])new Object[]{resourceProvider.getInstance(null)});
                    } else {
                        LOGGER.error("registerServiceInstance() CxfJAXRSPlugin not found in classLoader {}", new Object[]{pluginClassLoader});
                    }
                }
                catch (Exception e) {
                    LOGGER.error("registerServiceInstance() exception {}", (Throwable)e, new Object[0]);
                }
            }
            return method.invoke((Object)this.delegate, args);
        }
    }
}

