/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cxf.jaxrs;

import java.util.Objects;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cxf.jaxrs.ClassResourceInfoProxyHelper;

public class CxfJAXRSCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CxfJAXRSCommand.class);
    private ClassLoader classLoader;
    private ClassResourceInfo criProxy;
    private String resourceClassPath;

    public void setupCmd(ClassLoader classLoader, Object criProxy) {
        this.classLoader = classLoader;
        this.criProxy = (ClassResourceInfo)criProxy;
        this.resourceClassPath = this.criProxy.getServiceClass().toString();
    }

    public void executeCommand() {
        LOGGER.debug("Reloading service={}, in classLoader={}", new Object[]{this.criProxy.getServiceClass(), this.classLoader});
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ClassResourceInfoProxyHelper.reloadClassResourceInfo(this.criProxy);
            LOGGER.info("Resource class {} reloaded.", new Object[]{this.criProxy.getResourceClass().getName()});
        }
        catch (Exception e) {
            LOGGER.error("Could not reload JAXRS service class {}", (Throwable)e, new Object[]{this.criProxy.getServiceClass()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        CxfJAXRSCommand that = (CxfJAXRSCommand)((Object)object);
        return Objects.equals(this.resourceClassPath, that.resourceClassPath);
    }

    public int hashCode() {
        return Objects.hash(this.resourceClassPath);
    }

    public String toString() {
        return "CxfJAXRSCommand[classLoader=" + this.classLoader + ", service class =" + this.criProxy.getServiceClass() + "]";
    }
}

