/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cxf.jaxrs.CxfJAXRSCommand;
import org.hotswap.agent.plugin.cxf.jaxrs.CxfJAXRSTransformer;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="CxfJAXRS", description="CXF-JAXRS plugin for JAXRS CXF frontend. Reload jaxrs resource on resource class change. Reinject resource's injection points.", testedVersions={"3.2.7"}, expectedVersions={"3.2.7"}, supportClass={CxfJAXRSTransformer.class})
public class CxfJAXRSPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CxfJAXRSPlugin.class);
    private static final Set<String> PATH_ANNOTATIONS = new HashSet<String>(Arrays.asList("jakarta.ws.rs.Path", "javax.ws.rs.Path"));
    private static final int WAIT_ON_REDEFINE = 300;
    private static final int WAIT_ON_CREATE = 600;
    @Init
    ClassLoader appClassLoader;
    @Init
    Scheduler scheduler;
    Map<String, Object> classResourceInfoRegistry = new HashMap<String, Object>();
    WeakHashMap<Object, Boolean> serviceInstances = new WeakHashMap();
    WeakHashMap<Object, Boolean> jaxbProviderRegistry = new WeakHashMap();

    @Init
    public void init(PluginConfiguration pluginConfiguration) {
        LOGGER.info("CxfJAXRSPlugin initialized.", new Object[0]);
    }

    public void registerClassResourceInfo(Class<?> serviceClass, Object classResourceInfo) {
        this.classResourceInfoRegistry.put(serviceClass.getName(), classResourceInfo);
        LOGGER.debug("Registered service {} ", new Object[]{serviceClass.getClass().getName()});
    }

    public void registerJAXBProvider(Object jaxbProvider) {
        this.jaxbProviderRegistry.put(jaxbProvider, Boolean.TRUE);
        LOGGER.debug("Registered JAXB Provider {} ", new Object[]{jaxbProvider});
    }

    public boolean containsServiceInstance(Class<?> serviceClass) {
        for (Object provider : this.serviceInstances.keySet()) {
            if (!provider.getClass().getName().equals(serviceClass.getName())) continue;
            return true;
        }
        return false;
    }

    public List<Object> getServiceInstances(Class<?> serviceClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object service : this.serviceInstances.keySet()) {
            if (!service.getClass().getName().equals(serviceClass.getName())) continue;
            result.add(service);
        }
        return result;
    }

    public void registerServiceInstance(Object serviceInstance) {
        this.serviceInstances.put(serviceInstance, Boolean.TRUE);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(ClassLoader classLoader, CtClass clazz, Class<?> original) {
        if (this.isSyntheticClass(clazz.getName())) {
            LOGGER.trace("Skipping synthetic class {}.", new Object[]{clazz.getName()});
            return;
        }
        if (AnnotationHelper.hasAnnotation(original, PATH_ANNOTATIONS) || AnnotationHelper.hasAnnotation((CtClass)clazz, PATH_ANNOTATIONS)) {
            if (LOGGER.isLevelEnabled(AgentLogger.Level.TRACE)) {
                LOGGER.trace("Reload @Path annotated class {}", new Object[]{clazz.getName()});
            }
            this.refreshClass(classLoader, clazz.getName(), original, 300);
        }
        this.clearJAXBProviderContexts();
    }

    private void refreshClass(ClassLoader classLoader, String className, Class<?> original, int timeout) {
        try {
            Object classResourceInfoProxy = this.classResourceInfoRegistry.get(className);
            if (classResourceInfoProxy == null) {
                LOGGER.debug("refreshClass() ClassResourceInfo proxy not found for classResourceInfo={}.", new Object[]{className});
                return;
            }
            Class<?> cmdClass = Class.forName(CxfJAXRSCommand.class.getName(), true, this.appClassLoader);
            Command cmd = (Command)cmdClass.newInstance();
            ReflectionHelper.invoke((Object)cmd, cmdClass, (String)"setupCmd", (Class[])new Class[]{ClassLoader.class, Object.class}, (Object[])new Object[]{classLoader, classResourceInfoProxy});
            this.scheduler.scheduleCommand(cmd, timeout);
        }
        catch (Exception e) {
            LOGGER.error("refreshClass() exception {}.", new Object[]{e.getMessage()});
        }
    }

    private void clearJAXBProviderContexts() {
        try {
            for (Object provider : this.jaxbProviderRegistry.keySet()) {
                ReflectionHelper.invoke((Object)provider, provider.getClass(), (String)"clearContexts", null, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("clearJAXBProviderContexts() exception {}.", new Object[]{e.getMessage()});
        }
    }

    private boolean isSyntheticClass(String className) {
        return className.contains("$$");
    }
}

