/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike.proxy;

import java.security.ProtectionDomain;
import java.util.HashMap;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.proxy.impl.AsmProxyClassGenerator;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.util.ReflectionHelper;

public class ProxyClassLoadingDelegate {
    private static final ThreadLocal<Boolean> MAGIC_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static final void beginProxyRegeneration() {
        MAGIC_IN_PROGRESS.set(true);
    }

    public static final void endProxyRegeneration() {
        MAGIC_IN_PROGRESS.remove();
    }

    public static Class<?> tryToLoadClassForName(String proxyClassName, Class<?> targetClass) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            return null;
        }
        return ClassUtils.tryToLoadClassForName((String)proxyClassName, targetClass);
    }

    public static Class<?> loadClass(ClassLoader loader, String className, byte[] bytes, ProtectionDomain protectionDomain) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            try {
                Class<?> originalProxyClass = loader.loadClass(className);
                try {
                    HashMap reloadMap = new HashMap();
                    reloadMap.put(originalProxyClass, bytes);
                    PluginManager.getInstance().hotswap(reloadMap);
                    return originalProxyClass;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return (Class)ReflectionHelper.invoke(null, AsmProxyClassGenerator.class, (String)"loadClass", (Class[])new Class[]{ClassLoader.class, String.class, byte[].class, ProtectionDomain.class}, (Object[])new Object[]{loader, className, bytes, protectionDomain});
        }
        catch (Exception exception) {
            return null;
        }
    }
}

