/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike.DeltaSpikeTransformers;
import org.hotswap.agent.plugin.deltaspike.jsf.ViewConfigReloadCommand;
import org.hotswap.agent.plugin.deltaspike.proxy.PartialBeanClassRefreshCommand;
import org.hotswap.agent.util.AnnotationHelper;

@Plugin(name="Deltaspike", description="Apache DeltaSpike (http://deltaspike.apache.org/), support repository reloading", testedVersions={"1.5.2, 1.7.2"}, expectedVersions={"1.5-1.7"}, supportClass={DeltaSpikeTransformers.class})
public class DeltaSpikePlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(DeltaSpikePlugin.class);
    private static final String REPOSITORY_ANNOTATION = "org.apache.deltaspike.data.api.Repository";
    private static final int WAIT_ON_REDEFINE = 1000;
    @Init
    ClassLoader appClassLoader;
    @Init
    Scheduler scheduler;
    Map<Object, String> registeredRepoComponents = new WeakHashMap<Object, String>();
    Map<Object, String> registeredPartialBeans = new WeakHashMap<Object, String>();
    Map<Object, List<String>> registeredViewConfExtRootClasses = new WeakHashMap<Object, List<String>>();

    public void registerRepoComponent(Object repoComponent, Class<?> repositoryClass) {
        if (!this.registeredRepoComponents.containsKey(repoComponent)) {
            LOGGER.debug("DeltaspikePlugin - Repository Component registered : {}", new Object[]{repositoryClass.getName()});
        }
        this.registeredRepoComponents.put(repoComponent, repositoryClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPartialBean(Object bean, Class<?> partialBeanClass) {
        Map<Object, String> map = this.registeredPartialBeans;
        synchronized (map) {
            this.registeredPartialBeans.put(bean, partialBeanClass.getName());
        }
        LOGGER.debug("Registering partial bean : {}", new Object[]{partialBeanClass.getName()});
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(CtClass clazz, Class original) {
        this.checkRefreshPartialBean(clazz, original);
        this.checkRefreshViewConfigExtension(clazz, original);
    }

    private void checkRefreshPartialBean(CtClass clazz, Class original) {
        Object partialBean = this.getObjectByName(this.registeredPartialBeans, clazz.getName());
        if (partialBean != null) {
            Object repositoryComponent;
            PartialBeanClassRefreshCommand cmd = new PartialBeanClassRefreshCommand(this.appClassLoader, partialBean, clazz.getName());
            if (AnnotationHelper.hasAnnotation((CtClass)clazz, (String)REPOSITORY_ANNOTATION) && (repositoryComponent = this.getObjectByName(this.registeredRepoComponents, clazz.getName())) != null) {
                cmd.setRepositoryComponent(repositoryComponent);
            }
            this.scheduler.scheduleCommand((Command)cmd, 1000);
        }
    }

    private Object getObjectByName(Map<Object, String> registeredComponents, String className) {
        for (Map.Entry<Object, String> entry : registeredComponents.entrySet()) {
            if (!className.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void checkRefreshViewConfigExtension(CtClass clazz, Class original) {
        String className = original.getName();
        int index = className.indexOf("$");
        String rootClassName = index != -1 ? className.substring(0, index) : className;
        for (Map.Entry<Object, List<String>> entry : this.registeredViewConfExtRootClasses.entrySet()) {
            List<String> rootClassNameList = entry.getValue();
            for (String viewConfigClassName : rootClassNameList) {
                if (!viewConfigClassName.equals(rootClassName)) continue;
                this.scheduler.scheduleCommand((Command)new ViewConfigReloadCommand(this.appClassLoader, entry.getKey(), entry.getValue()), 1000);
                return;
            }
        }
    }

    public void registerViewConfigRootClasses(Object viewConfigExtension, List rootClassList) {
        if (rootClassList != null) {
            ArrayList<String> rootClassNameList = new ArrayList<String>();
            for (Object viewConfigClassObj : rootClassList) {
                Class viewConfigClass = (Class)viewConfigClassObj;
                LOGGER.debug("Registering ViewConfigRoot class : {}", new Object[]{viewConfigClass.getName()});
                rootClassNameList.add(viewConfigClass.getName());
            }
            this.registeredViewConfExtRootClasses.put(viewConfigExtension, rootClassNameList);
        }
    }
}

