/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike.proxy;

import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.partialbean.impl.PartialBeanProxyFactory;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike.proxy.ProxyClassLoadingDelegate;
import org.hotswap.agent.util.ReflectionHelper;

public class PartialBeanClassRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PartialBeanClassRefreshAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPartialBeanClass(ClassLoader classLoader, Object partialBean) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ProxyClassLoadingDelegate.beginProxyRegeneration();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object lifecycle = ReflectionHelper.get((Object)partialBean, (String)"lifecycle");
            if (lifecycle != null) {
                Class targetClass = (Class)ReflectionHelper.get((Object)lifecycle, (String)"targetClass");
                PartialBeanProxyFactory proxyFactory = PartialBeanProxyFactory.getInstance();
                try {
                    Method m3 = PartialBeanProxyFactory.class.getMethod("getProxyClass", BeanManager.class, Class.class, Class.class);
                    Class delegateInvocationHandlerClass = (Class)ReflectionHelper.get((Object)lifecycle, (String)"delegateInvocationHandlerClass");
                    m3.invoke((Object)proxyFactory, BeanManagerProvider.getInstance().getBeanManager(), targetClass, delegateInvocationHandlerClass);
                }
                catch (NoSuchMethodException e) {
                    Method m2 = PartialBeanProxyFactory.class.getMethod("getProxyClass", BeanManager.class, Class.class);
                    m2.invoke((Object)proxyFactory, BeanManagerProvider.getInstance().getBeanManager(), targetClass);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Deltaspike proxy redefinition failed", (Throwable)e, new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
        }
    }
}

