/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike.jsf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike.jsf.ViewConfigReloader;

public class ViewConfigReloadCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ViewConfigReloadCommand.class);
    ClassLoader classLoader;
    Object viewConfigExtension;
    List<String> rootClassNameList;

    public ViewConfigReloadCommand(ClassLoader classLoader, Object viewConfigExtension, List<String> rootClassNameList) {
        this.classLoader = classLoader;
        this.viewConfigExtension = viewConfigExtension;
        this.rootClassNameList = rootClassNameList;
    }

    public void executeCommand() {
        try {
            LOGGER.debug("Executing ViewConfigReloader.reloadViewConfig('{}')", new Object[]{this.rootClassNameList});
            Class<?> reloaderClazz = Class.forName(ViewConfigReloader.class.getName(), true, this.classLoader);
            Method m = reloaderClazz.getDeclaredMethod("reloadViewConfig", ClassLoader.class, Object.class, List.class);
            m.invoke(null, this.classLoader, this.viewConfigExtension, this.rootClassNameList);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing classes '{}' in classLoader {}", (Throwable)e, new Object[]{this.rootClassNameList, this.classLoader});
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ViewConfigReloadCommand that = (ViewConfigReloadCommand)((Object)o);
        if (!this.classLoader.equals(that.classLoader)) {
            return false;
        }
        if (!this.viewConfigExtension.equals(that.viewConfigExtension)) {
            return false;
        }
        return this.rootClassNameList.equals(that.rootClassNameList);
    }

    public int hashCode() {
        int result = this.classLoader.hashCode();
        result = 31 * result + (this.rootClassNameList != null ? this.rootClassNameList.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ViewConfigExtensionRefreshCommand{classLoader=" + this.classLoader + ", viewConfigRootClassNames='" + this.rootClassNameList + '\'' + '}';
    }
}

